/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.scoreboard.Sidebar;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ScoreboardObjectivePacket(@NotNull String objectiveName, byte mode, @Nullable Component objectiveValue, @Nullable Type type, @Nullable Sidebar.NumberFormat numberFormat) implements ComponentHoldingServerPacket
{
    public ScoreboardObjectivePacket(@NotNull NetworkBuffer reader) {
        this(ScoreboardObjectivePacket.read(reader));
    }

    private ScoreboardObjectivePacket(ScoreboardObjectivePacket packet) {
        this(packet.objectiveName, packet.mode, packet.objectiveValue, packet.type, packet.numberFormat);
    }

    private static ScoreboardObjectivePacket read(@NotNull NetworkBuffer reader) {
        String objectiveName = reader.read(NetworkBuffer.STRING);
        byte mode = reader.read(NetworkBuffer.BYTE);
        Component objectiveValue = null;
        Type type = null;
        Sidebar.NumberFormat numberFormat = null;
        if (mode == 0 || mode == 2) {
            objectiveValue = reader.read(NetworkBuffer.COMPONENT);
            type = Type.values()[reader.read(NetworkBuffer.VAR_INT)];
            numberFormat = reader.readOptional(Sidebar.NumberFormat::new);
        }
        return new ScoreboardObjectivePacket(objectiveName, mode, objectiveValue, type, numberFormat);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.objectiveName);
        writer.write(NetworkBuffer.BYTE, this.mode);
        if (this.mode == 0 || this.mode == 2) {
            assert (this.objectiveValue != null);
            writer.write(NetworkBuffer.COMPONENT, this.objectiveValue);
            assert (this.type != null);
            writer.write(NetworkBuffer.VAR_INT, this.type.ordinal());
            writer.writeOptional(this.numberFormat);
        }
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.SCOREBOARD_OBJECTIVE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return this.mode == 0 || this.mode == 2 ? List.of(this.objectiveValue) : List.of();
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return this.mode == 0 || this.mode == 2 ? new ScoreboardObjectivePacket(this.objectiveName, this.mode, (Component)operator.apply(this.objectiveValue), this.type, this.numberFormat) : this;
    }

    public static enum Type {
        INTEGER,
        HEARTS;

    }
}

