/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.Scheduler;
import net.minestom.server.timer.TaskImpl;
import net.minestom.server.timer.TaskSchedule;
import org.jetbrains.annotations.NotNull;

public sealed interface Task
permits TaskImpl {
    public int id();

    @NotNull
    public ExecutionType executionType();

    @NotNull
    public Scheduler owner();

    public void unpark();

    public boolean isParked();

    public void cancel();

    public boolean isAlive();

    public static final class Builder {
        private final Scheduler scheduler;
        private final Supplier<TaskSchedule> innerTask;
        private ExecutionType executionType = ExecutionType.TICK_START;
        private TaskSchedule delay = TaskSchedule.immediate();
        private TaskSchedule repeat = TaskSchedule.stop();
        private boolean repeatOverride;

        Builder(Scheduler scheduler, Supplier<TaskSchedule> innerTask) {
            this.scheduler = scheduler;
            this.innerTask = innerTask;
        }

        Builder(Scheduler scheduler, Runnable runnable) {
            this.scheduler = scheduler;
            this.innerTask = () -> {
                runnable.run();
                return TaskSchedule.stop();
            };
        }

        @NotNull
        public Builder executionType(@NotNull ExecutionType executionType) {
            this.executionType = executionType;
            return this;
        }

        @NotNull
        public Builder delay(@NotNull TaskSchedule schedule) {
            this.delay = schedule;
            return this;
        }

        @NotNull
        public Builder repeat(@NotNull TaskSchedule schedule) {
            this.repeat = schedule;
            this.repeatOverride = true;
            return this;
        }

        @NotNull
        public Task schedule() {
            final Supplier<TaskSchedule> innerTask = this.innerTask;
            final TaskSchedule delay = this.delay;
            final TaskSchedule repeat = this.repeat;
            final boolean repeatOverride = this.repeatOverride;
            ExecutionType executionType = this.executionType;
            return this.scheduler.submitTask(new Supplier<TaskSchedule>(this){
                boolean first = true;

                @Override
                public TaskSchedule get() {
                    if (this.first) {
                        this.first = false;
                        return delay;
                    }
                    TaskSchedule schedule = (TaskSchedule)innerTask.get();
                    if (repeatOverride) {
                        return repeat;
                    }
                    return schedule;
                }
            }, executionType);
        }

        @NotNull
        public Builder delay(@NotNull Duration duration) {
            return this.delay(TaskSchedule.duration(duration));
        }

        @NotNull
        public Builder delay(long time, @NotNull TemporalUnit unit) {
            return this.delay(Duration.of(time, unit));
        }

        @NotNull
        public Builder repeat(@NotNull Duration duration) {
            return this.repeat(TaskSchedule.duration(duration));
        }

        @NotNull
        public Builder repeat(long time, @NotNull TemporalUnit unit) {
            return this.repeat(Duration.of(time, unit));
        }
    }
}

