/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryTag;
import net.minestom.server.registry.RegistryTagImpl;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

final class RegistryNetworkTypes {
    RegistryNetworkTypes() {
    }

    record RegistryTagImpl<T>(@NotNull Registries.Selector<T> selector) implements NetworkBuffer.Type<RegistryTag<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, RegistryTag<T> value) {
            RegistryTag<T> registryTag = value;
            Objects.requireNonNull(registryTag);
            RegistryTag<T> registryTag2 = registryTag;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegistryTagImpl.Backed.class, RegistryTagImpl.Empty.class, RegistryTagImpl.Direct.class}, registryTag2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    RegistryTagImpl.Backed backed = (RegistryTagImpl.Backed)registryTag2;
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    buffer.write(NetworkBuffer.KEY, backed.key().key());
                    break;
                }
                case 1: {
                    RegistryTagImpl.Empty empty = (RegistryTagImpl.Empty)registryTag2;
                    buffer.write(NetworkBuffer.VAR_INT, 1);
                    break;
                }
                case 2: {
                    List entries;
                    RegistryTagImpl.Direct direct = (RegistryTagImpl.Direct)registryTag2;
                    try {
                        List list;
                        entries = list = direct.keys();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
                    Registry<T> registry = this.selector.select(registries);
                    buffer.write(NetworkBuffer.VAR_INT, entries.size() + 1);
                    for (RegistryKey key : entries) {
                        int id = registry.getId(key);
                        Check.stateCondition(id == -1, "Key {0} is not registered in registry {1}", key, registry.key());
                        buffer.write(NetworkBuffer.VAR_INT, id);
                    }
                    break;
                }
            }
        }

        @Override
        public RegistryTag<T> read(@NotNull NetworkBuffer buffer) {
            Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
            Registry<T> registry = this.selector.select(registries);
            int count = buffer.read(NetworkBuffer.VAR_INT) - 1;
            if (count < 0) {
                Key key = buffer.read(NetworkBuffer.KEY);
                RegistryTag<T> tag = registry.getTag(key);
                Check.stateCondition(tag == null, "No such tag {0} for registry {1}", key, registry.key());
                return tag;
            }
            if (count == 0) {
                return RegistryTag.empty();
            }
            ArrayList keys = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                int id = buffer.read(NetworkBuffer.VAR_INT);
                RegistryKey<int> key = registry.getKey((T)id);
                Check.stateCondition(key == null, "Unknown id {0} for registry {1}", id, registry.key());
                keys.add(key);
            }
            return new RegistryTagImpl.Direct(keys);
        }
    }

    record HolderNetworkTypeImpl<T>(@NotNull Registries.Selector<T> selector, @NotNull NetworkBuffer.Type<T> registryNetworkType) implements NetworkBuffer.Type<Holder<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Holder<T> value) {
            Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
            Registry<T> registry = this.selector.select(registries);
            Either<RegistryKey<T>, T> either = value.unwrap();
            Objects.requireNonNull(either);
            Either<RegistryKey<T>, T> either2 = either;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Either.Left.class, Either.Right.class}, either2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    RegistryKey registryKey;
                    Either.Left left = (Either.Left)either2;
                    RegistryKey key = registryKey = (RegistryKey)left.value();
                    int id = registry.getId(key);
                    Check.stateCondition(id == -1, "Key %s is not registered in registry %s", key, registry.key());
                    buffer.write(NetworkBuffer.VAR_INT, id + 1);
                    break;
                }
                case 1: {
                    Object direct;
                    Either.Right right = (Either.Right)either2;
                    try {
                        Object r;
                        direct = r = right.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    buffer.write(this.registryNetworkType, direct);
                    break;
                }
            }
        }

        @Override
        public Holder<T> read(@NotNull NetworkBuffer buffer) {
            Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
            Registry<T> registry = this.selector.select(registries);
            int id = buffer.read(NetworkBuffer.VAR_INT);
            if (id == 0) {
                return (Holder)buffer.read(this.registryNetworkType);
            }
            RegistryKey<int> key = registry.getKey((T)(id - 1));
            Check.stateCondition(key == null, "Unknown id %d for registry %s", id - 1, registry.key());
            return key;
        }
    }

    record RegistryKeyImpl<T>(@NotNull Registries.Selector<T> selector) implements NetworkBuffer.Type<RegistryKey<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, RegistryKey<T> value) {
            Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
            Registry<T> registry = this.selector.select(registries);
            int id = registry.getId(value);
            Check.stateCondition(id == -1, "Key %s is not registered in registry %s", value, registry.key());
            buffer.write(NetworkBuffer.VAR_INT, id);
        }

        @Override
        public RegistryKey<T> read(@NotNull NetworkBuffer buffer) {
            int id;
            Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
            Registry<T> registry = this.selector.select(registries);
            RegistryKey<int> key = registry.getKey((T)(id = buffer.read(NetworkBuffer.VAR_INT).intValue()));
            Check.stateCondition(key == null, "Unknown id %d for registry %s", id - 1, registry.key());
            return key;
        }
    }
}

