/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.network.packet.server.common.TagsPacket;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryTag;
import net.minestom.server.registry.StaticRegistry;
import net.minestom.server.registry.TagKey;
import net.minestom.server.registry.TagKeyImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Registry<T>
extends Keyed
permits StaticRegistry, DynamicRegistry {
    @Nullable
    public T get(int var1);

    @Nullable
    public T get(@NotNull Key var1);

    @Nullable
    default public T get(@NotNull RegistryKey<T> key) {
        return this.get(key.key());
    }

    @Nullable
    public RegistryKey<T> getKey(int var1);

    @Nullable
    public RegistryKey<T> getKey(@NotNull T var1);

    @Nullable
    public RegistryKey<T> getKey(@NotNull Key var1);

    public int getId(@NotNull RegistryKey<T> var1);

    @Nullable
    public DataPack getPack(int var1);

    @Nullable
    default public DataPack getPack(@NotNull RegistryKey<T> key) {
        int id = this.getId(key);
        return id == -1 ? null : this.getPack(id);
    }

    public int size();

    @NotNull
    public Collection<RegistryKey<T>> keys();

    @NotNull
    public Collection<T> values();

    @Nullable
    public RegistryTag<T> getTag(@NotNull TagKey<T> var1);

    @Nullable
    default public RegistryTag<T> getTag(@NotNull Key key) {
        return this.getTag(new TagKeyImpl(key));
    }

    @NotNull
    public RegistryTag<T> getOrCreateTag(@NotNull TagKey<T> var1);

    public boolean removeTag(@NotNull TagKey<T> var1);

    @NotNull
    public Collection<RegistryTag<T>> tags();

    @ApiStatus.Internal
    @NotNull
    public TagsPacket.Registry tagRegistry();
}

