/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.message;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.message.ChatTypeDecoration;
import net.minestom.server.message.ChatTypeImpl;
import net.minestom.server.message.ChatTypes;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.RegistryData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface ChatType
extends Holder.Direct<ChatType>,
ChatTypes
permits ChatTypeImpl {
    @NotNull
    public static final Codec<ChatType> REGISTRY_CODEC = StructCodec.struct("chat", ChatTypeDecoration.CODEC, ChatType::chat, "narration", ChatTypeDecoration.CODEC, ChatType::narration, ChatType::create);

    @NotNull
    public static ChatType create(@NotNull ChatTypeDecoration chat, @NotNull ChatTypeDecoration narration) {
        return new ChatTypeImpl(chat, narration);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<ChatType> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key((String)"minecraft:chat_type"), REGISTRY_CODEC, RegistryData.Resource.CHAT_TYPES);
    }

    @NotNull
    public ChatTypeDecoration chat();

    @NotNull
    public ChatTypeDecoration narration();

    public static final class Builder {
        private ChatTypeDecoration chat;
        private ChatTypeDecoration narration;

        private Builder() {
        }

        public Builder chat(@NotNull ChatTypeDecoration chat) {
            this.chat = chat;
            return this;
        }

        public Builder narration(@NotNull ChatTypeDecoration narration) {
            this.narration = narration;
            return this;
        }

        @NotNull
        public ChatType build() {
            return new ChatTypeImpl(this.chat, this.narration);
        }
    }
}

