/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.NotNull;

final class TranscoderJsonImpl
implements Transcoder<JsonElement> {
    public static final TranscoderJsonImpl INSTANCE = new TranscoderJsonImpl();

    TranscoderJsonImpl() {
    }

    @Override
    @NotNull
    public JsonElement createNull() {
        return JsonNull.INSTANCE;
    }

    @Override
    @NotNull
    public Result<Boolean> getBoolean(@NotNull JsonElement value) {
        if (!(value instanceof JsonPrimitive)) {
            return new Result.Error<Boolean>("Not a boolean: " + String.valueOf(value));
        }
        JsonPrimitive primitive = (JsonPrimitive)value;
        return new Result.Ok<Boolean>(primitive.getAsBoolean());
    }

    @Override
    @NotNull
    public JsonElement createBoolean(boolean value) {
        return new JsonPrimitive(Boolean.valueOf(value));
    }

    @Override
    @NotNull
    public Result<Byte> getByte(@NotNull JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Byte>("Not a byte: " + String.valueOf(value));
        }
        return new Result.Ok<Byte>(primitive.getAsByte());
    }

    @Override
    @NotNull
    public JsonElement createByte(byte value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @NotNull
    public Result<Short> getShort(@NotNull JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Short>("Not a short: " + String.valueOf(value));
        }
        return new Result.Ok<Short>(primitive.getAsShort());
    }

    @Override
    @NotNull
    public JsonElement createShort(short value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @NotNull
    public Result<Integer> getInt(@NotNull JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Integer>("Not an int: " + String.valueOf(value));
        }
        return new Result.Ok<Integer>(primitive.getAsInt());
    }

    @Override
    @NotNull
    public JsonElement createInt(int value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @NotNull
    public Result<Long> getLong(@NotNull JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Long>("Not a long: " + String.valueOf(value));
        }
        return new Result.Ok<Long>(primitive.getAsLong());
    }

    @Override
    @NotNull
    public JsonElement createLong(long value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @NotNull
    public Result<Float> getFloat(@NotNull JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Float>("Not a float: " + String.valueOf(value));
        }
        return new Result.Ok<Float>(Float.valueOf(primitive.getAsFloat()));
    }

    @Override
    @NotNull
    public JsonElement createFloat(float value) {
        return new JsonPrimitive((Number)Float.valueOf(value));
    }

    @Override
    @NotNull
    public Result<Double> getDouble(@NotNull JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Double>("Not a double: " + String.valueOf(value));
        }
        return new Result.Ok<Double>(primitive.getAsDouble());
    }

    @Override
    @NotNull
    public JsonElement createDouble(double value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @NotNull
    public Result<String> getString(@NotNull JsonElement value) {
        if (!(value instanceof JsonPrimitive)) {
            return new Result.Error<String>("Not a string: " + String.valueOf(value));
        }
        JsonPrimitive primitive = (JsonPrimitive)value;
        return new Result.Ok<String>(primitive.getAsString());
    }

    @Override
    @NotNull
    public JsonElement createString(@NotNull String value) {
        return new JsonPrimitive(value);
    }

    @Override
    @NotNull
    public Result<List<JsonElement>> getList(@NotNull JsonElement value) {
        if (!(value instanceof JsonArray)) {
            return new Result.Error<List<JsonElement>>("Not a list: " + String.valueOf(value));
        }
        final JsonArray array = (JsonArray)value;
        if (array.isEmpty()) {
            return new Result.Ok<List<JsonElement>>(List.of());
        }
        return new Result.Ok<List<JsonElement>>(new AbstractList<JsonElement>(this){

            @Override
            public JsonElement get(int index) {
                return array.get(index);
            }

            @Override
            public int size() {
                return array.size();
            }
        });
    }

    @Override
    @NotNull
    public JsonElement emptyList() {
        return new JsonArray();
    }

    @Override
    @NotNull
    public Transcoder.ListBuilder<JsonElement> createList(int expectedSize) {
        final JsonArray list = new JsonArray(expectedSize);
        return new Transcoder.ListBuilder<JsonElement>(this){

            @Override
            @NotNull
            public Transcoder.ListBuilder<JsonElement> add(JsonElement value) {
                list.add(value);
                return this;
            }

            @Override
            public JsonElement build() {
                return list;
            }
        };
    }

    @Override
    @NotNull
    public Result<Transcoder.MapLike<JsonElement>> getMap(@NotNull JsonElement value) {
        if (!(value instanceof JsonObject)) {
            return new Result.Error<Transcoder.MapLike<JsonElement>>("Not an object: " + String.valueOf(value));
        }
        final JsonObject object = (JsonObject)value;
        return new Result.Ok<Transcoder.MapLike<JsonElement>>(new Transcoder.MapLike<JsonElement>(this){

            @Override
            @NotNull
            public Collection<String> keys() {
                return object.keySet();
            }

            @Override
            public boolean hasValue(@NotNull String key) {
                return object.has(key);
            }

            @Override
            @NotNull
            public Result<JsonElement> getValue(@NotNull String key) {
                JsonElement element = object.get(key);
                if (element == null) {
                    return new Result.Error<JsonElement>("No such key: " + key);
                }
                return new Result.Ok<JsonElement>(element);
            }

            @Override
            public int size() {
                return object.size();
            }
        });
    }

    @Override
    @NotNull
    public JsonElement emptyMap() {
        return new JsonObject();
    }

    @Override
    @NotNull
    public Transcoder.MapBuilder<JsonElement> createMap() {
        final JsonObject object = new JsonObject();
        return new Transcoder.MapBuilder<JsonElement>(this){

            @Override
            @NotNull
            public Transcoder.MapBuilder<JsonElement> put(@NotNull JsonElement key, JsonElement value) {
                return this.put(key.getAsString(), value);
            }

            @Override
            @NotNull
            public Transcoder.MapBuilder<JsonElement> put(@NotNull String key, JsonElement value) {
                if (value != JsonNull.INSTANCE) {
                    object.add(key, value);
                }
                return this;
            }

            @Override
            public JsonElement build() {
                return object;
            }
        };
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public <O> Result<O> convertTo(@NotNull Transcoder<O> coder, @NotNull JsonElement value) {
        Result.Error error;
        JsonElement jsonElement = value;
        Objects.requireNonNull(jsonElement);
        JsonElement jsonElement2 = jsonElement;
        int n = 0;
        block21: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonObject.class, JsonArray.class, JsonPrimitive.class, JsonPrimitive.class, JsonPrimitive.class, JsonNull.class}, (Object)jsonElement2, n)) {
                case 0: {
                    String key;
                    JsonObject object = (JsonObject)jsonElement2;
                    Transcoder.MapBuilder<O> mapBuilder = coder.createMap();
                    block22: for (Map.Entry entry : object.entrySet()) {
                        String string;
                        Result.Error error2;
                        Result<O> result;
                        key = (String)entry.getKey();
                        Objects.requireNonNull(this.convertTo(coder, (JsonElement)entry.getValue()));
                        int n2 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result, n2)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                Result.Ok ok = (Result.Ok)result;
                                Result.Error data = error2 = ok.value();
                                mapBuilder.put(coder.createString(key), data);
                                continue block22;
                            }
                            case 1: 
                        }
                        error2 = (Result.Error)result;
                        String message = string = error2.message();
                        error = new Result.Error((String)key + ": " + message);
                        break block21;
                    }
                    error = new Result.Ok<O>(mapBuilder.build());
                    break block21;
                }
                case 1: {
                    String key;
                    JsonArray array = (JsonArray)jsonElement2;
                    if (array.isEmpty()) {
                        error = new Result.Ok<O>(coder.emptyList());
                        break block21;
                    }
                    Transcoder.ListBuilder<O> listBuilder = coder.createList(array.size());
                    block23: for (int i = 0; i < array.size(); ++i) {
                        Objects.requireNonNull(this.convertTo(coder, array.get(i)));
                        int n3 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, (Object)key, n3)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                Result.Error error3;
                                Result.Ok ok = (Result.Ok)((Object)key);
                                Result.Error data = error3 = ok.value();
                                listBuilder.add(data);
                                continue block23;
                            }
                            case 1: {
                                String string;
                                Result.Error error3 = (Result.Error)((Object)key);
                                String message = string = error3.message();
                                error = new Result.Error(i + ": " + message);
                                break block21;
                            }
                        }
                    }
                    error = new Result.Ok<O>(listBuilder.build());
                    break block21;
                }
                case 2: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                    if (!primitive.isBoolean()) {
                        n = 3;
                        continue block21;
                    }
                    error = new Result.Ok<O>(coder.createBoolean(primitive.getAsBoolean()));
                    break block21;
                }
                case 3: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                    if (!primitive.isNumber()) {
                        n = 4;
                        continue block21;
                    }
                    error = new Result.Ok<O>(coder.createDouble(primitive.getAsDouble()));
                    break block21;
                }
                case 4: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                    if (!primitive.isString()) {
                        n = 5;
                        continue block21;
                    }
                    error = new Result.Ok<O>(coder.createString(primitive.getAsString()));
                    break block21;
                }
                case 5: {
                    JsonNull jsonNull = (JsonNull)jsonElement2;
                    error = new Result.Ok<O>(coder.createNull());
                    break block21;
                }
                default: {
                    error = new Result.Error("Unknown JSON type: " + String.valueOf(value));
                    break block21;
                }
            }
            break;
        }
        return error;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

