package net.minestom.server.recipe;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by RecipeTypeGenerator
 */
public enum RecipeType implements StaticProtocolObject {
    CRAFTING(Key.key("crafting")),

    SMELTING(Key.key("smelting")),

    BLASTING(Key.key("blasting")),

    SMOKING(Key.key("smoking")),

    CAMPFIRE_COOKING(Key.key("campfire_cooking")),

    STONECUTTING(Key.key("stonecutting")),

    SMITHING(Key.key("smithing"));

    private static final Map<Key, RecipeType> BY_KEY = Arrays.stream(values()).collect(Collectors.toMap(RecipeType::key, Function.identity()));

    public static final NetworkBuffer.Type<RecipeType> NETWORK_TYPE = NetworkBuffer.Enum(RecipeType.class);

    public static final Codec<RecipeType> CODEC = Codec.KEY.transform(BY_KEY::get, RecipeType::key);

    private final Key key;

    RecipeType(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
