/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.snapshot;

import java.util.Collection;
import java.util.Objects;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.snapshot.ChunkSnapshot;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.ServerSnapshot;
import net.minestom.server.snapshot.Snapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biomes.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface InstanceSnapshot
extends Snapshot,
Block.Getter,
Biome.Getter,
TagReadable
permits SnapshotImpl.Instance {
    @NotNull
    public DimensionType dimensionType();

    public long worldAge();

    public long time();

    @Override
    default public @UnknownNullability Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
        ChunkSnapshot chunk = this.chunk(ChunkUtils.getChunkCoordinate(x), ChunkUtils.getChunkCoordinate(z));
        return Objects.requireNonNull(chunk).getBlock(x, y, z, condition);
    }

    @Override
    @NotNull
    default public Biome getBiome(int x, int y, int z) {
        ChunkSnapshot chunk = this.chunk(ChunkUtils.getChunkCoordinate(x), ChunkUtils.getChunkCoordinate(z));
        return Objects.requireNonNull(chunk).getBiome(x, y, z);
    }

    @Nullable
    public ChunkSnapshot chunk(int var1, int var2);

    @Nullable
    default public ChunkSnapshot chunkAt(@NotNull Point point) {
        return this.chunk(point.chunkX(), point.chunkZ());
    }

    @NotNull
    public @NotNull Collection<@NotNull ChunkSnapshot> chunks();

    @NotNull
    public @NotNull Collection<@NotNull EntitySnapshot> entities();

    @NotNull
    public ServerSnapshot server();
}

