/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.sound.Sound;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record EntitySoundEffectPacket(@Nullable SoundEvent soundEvent, @Nullable String soundName, @Nullable Float range, @NotNull Sound.Source source, int entityId, float volume, float pitch, long seed) implements ServerPacket.Play
{
    public EntitySoundEffectPacket(@Nullable SoundEvent soundEvent, @Nullable String soundName, @Nullable Float range, @NotNull Sound.Source source, int entityId, float volume, float pitch, long seed) {
        Check.argCondition(soundEvent == null && soundName == null, "soundEvent and soundName cannot both be null");
        Check.argCondition(soundEvent != null && soundName != null, "soundEvent and soundName cannot both be present");
        Check.argCondition(soundName == null && range != null, "range cannot be present if soundName is null");
    }

    public EntitySoundEffectPacket(@NotNull SoundEvent soundEvent, @Nullable Float range, @NotNull Sound.Source source, int entityId, float volume, float pitch, long seed) {
        this(soundEvent, null, range, source, entityId, volume, pitch, seed);
    }

    public EntitySoundEffectPacket(@NotNull String soundName, @Nullable Float range, @NotNull Sound.Source source, int entityId, float volume, float pitch, long seed) {
        this(null, soundName, range, source, entityId, volume, pitch, seed);
    }

    public EntitySoundEffectPacket(@NotNull NetworkBuffer reader) {
        this(EntitySoundEffectPacket.fromReader(reader));
    }

    private EntitySoundEffectPacket(@NotNull EntitySoundEffectPacket packet) {
        this(packet.soundEvent, packet.soundName, packet.range, packet.source, packet.entityId, packet.volume, packet.pitch, packet.seed);
    }

    @NotNull
    private static EntitySoundEffectPacket fromReader(@NotNull NetworkBuffer reader) {
        String soundName;
        SoundEvent soundEvent;
        int soundId = reader.read(NetworkBuffer.VAR_INT);
        Float range = null;
        if (soundId == 0) {
            soundEvent = null;
            soundName = reader.read(NetworkBuffer.STRING);
            range = reader.readOptional(NetworkBuffer.FLOAT);
        } else {
            soundEvent = SoundEvent.fromId(soundId - 1);
            soundName = null;
        }
        return new EntitySoundEffectPacket(soundEvent, soundName, range, reader.readEnum(Sound.Source.class), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.LONG));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        if (this.soundEvent != null) {
            writer.write(NetworkBuffer.VAR_INT, this.soundEvent.id() + 1);
        } else {
            writer.write(NetworkBuffer.VAR_INT, 0);
            writer.write(NetworkBuffer.STRING, this.soundName);
            writer.writeOptional(NetworkBuffer.FLOAT, this.range);
        }
        writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getSoundSourceValue(this.source));
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.volume));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.pitch));
        writer.write(NetworkBuffer.LONG, this.seed);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.ENTITY_SOUND_EFFECT;
    }
}

