/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.heightmap;

import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTLongArray;

public abstract class Heightmap {
    private final short[] heights = new short[256];
    private final Chunk chunk;
    private final int minHeight;
    private boolean needsRefresh = true;

    public Heightmap(Chunk chunk) {
        this.chunk = chunk;
        this.minHeight = chunk.getInstance().getDimensionType().getMinY() - 1;
    }

    protected abstract boolean checkBlock(@NotNull Block var1);

    public abstract String NBTName();

    public void refresh(int x, int y, int z, Block block) {
        if (this.checkBlock(block)) {
            if (this.getHeight(x, z) < y) {
                this.setHeightY(x, z, y);
            }
        } else if (y == this.getHeight(x, z)) {
            this.refresh(x, z, y - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(int startY) {
        if (!this.needsRefresh) {
            return;
        }
        Chunk chunk = this.chunk;
        synchronized (chunk) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.refresh(x, z, startY);
                }
            }
        }
        this.needsRefresh = false;
    }

    public void refresh(int x, int z, int startY) {
        int y = startY;
        while (y > this.minHeight) {
            Block block = this.chunk.getBlock(x, y, z, Block.Getter.Condition.TYPE);
            if (block == null) continue;
            if (this.checkBlock(block)) break;
            --y;
        }
        this.setHeightY(x, z, y);
    }

    public NBTLongArray getNBT() {
        int dimensionHeight = this.chunk.getInstance().getDimensionType().getHeight();
        int bitsForHeight = MathUtils.bitsToRepresent(dimensionHeight);
        return NBT.LongArray((long[])Heightmap.encode(this.heights, bitsForHeight));
    }

    public void loadFrom(ImmutableLongArray data) {
        int dimensionHeight = this.chunk.getInstance().getDimensionType().getHeight();
        int bitsPerEntry = MathUtils.bitsToRepresent(dimensionHeight);
        int entriesPerLong = 64 / bitsPerEntry;
        int maxPossibleIndexInContainer = entriesPerLong - 1;
        int entryMask = (1 << bitsPerEntry) - 1;
        int containerIndex = 0;
        for (int i = 0; i < this.heights.length; ++i) {
            int indexInContainer = i % entriesPerLong;
            this.heights[i] = (short)((int)(data.get(containerIndex) >> indexInContainer * bitsPerEntry) & entryMask);
            if (indexInContainer != maxPossibleIndexInContainer) continue;
            ++containerIndex;
        }
        this.needsRefresh = false;
    }

    public int getHeight(int x, int z) {
        if (this.needsRefresh) {
            this.refresh(Heightmap.getHighestBlockSection(this.chunk));
        }
        return this.heights[z << 4 | x] + this.minHeight;
    }

    private void setHeightY(int x, int z, int height) {
        this.heights[z << 4 | x] = (short)(height - this.minHeight);
    }

    public static int getHighestBlockSection(Chunk chunk) {
        int sectionY;
        Palette blockPalette;
        int y = chunk.getInstance().getDimensionType().getMaxY();
        int sectionsCount = chunk.getMaxSection() - chunk.getMinSection();
        for (int i = 0; i < sectionsCount && (blockPalette = chunk.getSection(sectionY = chunk.getMaxSection() - i - 1).blockPalette()).count() == 0; ++i) {
            y -= 16;
        }
        return y;
    }

    static long[] encode(short[] heights, int bitsPerEntry) {
        int entriesPerLong = 64 / bitsPerEntry;
        int len = (heights.length + entriesPerLong - 1) / entriesPerLong;
        int maxPossibleIndexInContainer = entriesPerLong - 1;
        int entryMask = (1 << bitsPerEntry) - 1;
        long[] data = new long[len];
        int containerIndex = 0;
        for (int i = 0; i < heights.length; ++i) {
            int indexInContainer = i % entriesPerLong;
            short entry = heights[i];
            int n = containerIndex++;
            data[n] = data[n] | (long)(entry & entryMask) << indexInContainer * bitsPerEntry;
            if (indexInContainer != maxPossibleIndexInContainer) continue;
        }
        return data;
    }
}

