/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.monster.zombie;

import net.minestom.server.collision.BoundingBox;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.monster.MonsterMeta;
import org.jetbrains.annotations.NotNull;

public class ZombieMeta
extends MonsterMeta {
    public static final byte OFFSET = 16;
    public static final byte MAX_OFFSET = 19;

    public ZombieMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    public boolean isBaby() {
        return this.metadata.getIndex(16, false);
    }

    public void setBaby(boolean value) {
        if (this.isBaby() == value) {
            return;
        }
        this.consumeEntity(entity -> {
            BoundingBox bb = entity.getBoundingBox();
            if (value) {
                double width = bb.width() / 2.0;
                entity.setBoundingBox(width, bb.height() / 2.0, width);
            } else {
                double width = bb.width() * 2.0;
                entity.setBoundingBox(width, bb.height() * 2.0, width);
            }
        });
        this.metadata.setIndex(16, Metadata.Boolean(value));
    }

    public boolean isBecomingDrowned() {
        return this.metadata.getIndex(18, false);
    }

    public void setBecomingDrowned(boolean value) {
        this.metadata.setIndex(18, Metadata.Boolean(value));
    }
}

