/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.common;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ResourcePackPushPacket(@NotNull UUID id, @NotNull String url, @NotNull String hash, boolean forced, @Nullable Component prompt) implements ServerPacket.Configuration,
ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public ResourcePackPushPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.UUID), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.BOOLEAN), reader.readOptional(NetworkBuffer.COMPONENT));
    }

    public ResourcePackPushPacket(@NotNull ResourcePackInfo resourcePackInfo, boolean required, @Nullable Component prompt) {
        this(resourcePackInfo.id(), resourcePackInfo.uri().toString(), resourcePackInfo.hash(), required, prompt);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.UUID, this.id);
        writer.write(NetworkBuffer.STRING, this.url);
        writer.write(NetworkBuffer.STRING, this.hash);
        writer.write(NetworkBuffer.BOOLEAN, this.forced);
        writer.writeOptional(NetworkBuffer.COMPONENT, this.prompt);
    }

    @Override
    public int configurationId() {
        return ServerPacketIdentifier.CONFIGURATION_RESOURCE_PACK_PUSH;
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.RESOURCE_PACK_PUSH;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return List.of(this.prompt);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new ResourcePackPushPacket(this.id, this.url, this.hash, this.forced, (Component)operator.apply(this.prompt));
    }
}

