/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.particle.Particle;
import net.minestom.server.particle.data.ParticleData;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ParticlePacket(int particleId, boolean longDistance, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float maxSpeed, int particleCount, @Nullable ParticleData data) implements ServerPacket.Play
{
    private ParticlePacket(ParticlePacket copy) {
        this(copy.particleId, copy.longDistance, copy.x, copy.y, copy.z, copy.offsetX, copy.offsetY, copy.offsetZ, copy.maxSpeed, copy.particleCount, copy.data);
    }

    public ParticlePacket(@NotNull NetworkBuffer reader) {
        this(ParticlePacket.readPacket(reader));
    }

    public ParticlePacket(@NotNull Particle particle, boolean longDistance, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float maxSpeed, int particleCount) {
        this(particle.id(), longDistance, x, y, z, offsetX, offsetY, offsetZ, maxSpeed, particleCount, particle.data());
    }

    public ParticlePacket(@NotNull Particle particle, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float maxSpeed, int particleCount) {
        this(particle.id(), false, x, y, z, offsetX, offsetY, offsetZ, maxSpeed, particleCount, particle.data());
    }

    private static ParticlePacket readPacket(NetworkBuffer reader) {
        int particleId = reader.read(NetworkBuffer.VAR_INT);
        Boolean longDistance = reader.read(NetworkBuffer.BOOLEAN);
        Double x = reader.read(NetworkBuffer.DOUBLE);
        Double y = reader.read(NetworkBuffer.DOUBLE);
        Double z = reader.read(NetworkBuffer.DOUBLE);
        Float offsetX = reader.read(NetworkBuffer.FLOAT);
        Float offsetY = reader.read(NetworkBuffer.FLOAT);
        Float offsetZ = reader.read(NetworkBuffer.FLOAT);
        Float maxSpeed = reader.read(NetworkBuffer.FLOAT);
        Integer particleCount = reader.read(NetworkBuffer.INT);
        ParticleData data = ParticleData.read(particleId, reader);
        return new ParticlePacket(particleId, longDistance, x, y, z, offsetX.floatValue(), offsetY.floatValue(), offsetZ.floatValue(), maxSpeed.floatValue(), particleCount, data);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        Check.stateCondition(this.data != null && !this.data.validate(this.particleId), "Particle data {0} is not valid for this particle type {1}", this.data, Particle.fromId(this.particleId));
        Check.stateCondition(this.data == null && ParticleData.requiresData(this.particleId), "Particle data is required for this particle type {0}", Particle.fromId(this.particleId));
        writer.write(NetworkBuffer.VAR_INT, this.particleId);
        writer.write(NetworkBuffer.BOOLEAN, this.longDistance);
        writer.write(NetworkBuffer.DOUBLE, this.x);
        writer.write(NetworkBuffer.DOUBLE, this.y);
        writer.write(NetworkBuffer.DOUBLE, this.z);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.offsetX));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.offsetY));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.offsetZ));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.maxSpeed));
        writer.write(NetworkBuffer.INT, this.particleCount);
        if (this.data != null) {
            this.data.write(writer);
        }
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.PARTICLE;
    }
}

