/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.other;

import java.util.Locale;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.ObjectDataProvider;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintingMeta
extends EntityMeta
implements ObjectDataProvider {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 9;
    private Orientation orientation = null;

    public PaintingMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Variant getVariant() {
        return this.metadata.getIndex(8, Variant.KEBAB);
    }

    public void setVariant(@NotNull Variant value) {
        this.metadata.setIndex(8, Metadata.PaintingVariant(value));
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public int getObjectData() {
        Check.stateCondition(this.orientation == null, "Painting orientation must be set before spawn");
        return this.orientation.id();
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return false;
    }

    public static enum Orientation {
        NORTH(2),
        SOUTH(3),
        WEST(4),
        EAST(5);

        private final int id;

        private Orientation(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }

    public static enum Variant implements StaticProtocolObject
    {
        KEBAB(16, 16),
        AZTEC(16, 16),
        ALBAN(16, 16),
        AZTEC2(16, 16),
        BOMB(16, 16),
        PLANT(16, 16),
        WASTELAND(16, 16),
        POOL(32, 16),
        COURBET(32, 16),
        SEA(32, 16),
        SUNSET(32, 16),
        CREEBET(32, 16),
        WANDERER(16, 32),
        GRAHAM(16, 32),
        MATCH(32, 32),
        BUST(32, 32),
        STAGE(32, 32),
        VOID(32, 32),
        SKULL_AND_ROSES(32, 32),
        WITHER(32, 32),
        FIGHTERS(64, 32),
        POINTER(64, 64),
        PIGSCENE(64, 64),
        BURNING_SKULL(64, 64),
        SKELETON(64, 48),
        EARTH(32, 32),
        WIND(32, 32),
        WATER(32, 32),
        FIRE(32, 32),
        DONKEY_KONG(64, 48);

        private static final Variant[] VALUES;
        private final NamespaceID namespace = NamespaceID.from("minecraft", this.name().toLowerCase(Locale.ROOT));
        private final int width;
        private final int height;

        @Nullable
        public static Variant fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                return null;
            }
            return VALUES[id];
        }

        @Nullable
        public static Variant fromNamespaceId(@Nullable String namespaceId) {
            if (namespaceId == null) {
                return null;
            }
            return Variant.fromNamespaceId(NamespaceID.from(namespaceId));
        }

        @Nullable
        public static Variant fromNamespaceId(@Nullable NamespaceID namespaceId) {
            if (namespaceId == null) {
                return null;
            }
            for (Variant value : VALUES) {
                if (!value.namespace().equals(namespaceId)) continue;
                return value;
            }
            return null;
        }

        private Variant(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int id() {
            return this.ordinal();
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        @Override
        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        static {
            VALUES = Variant.values();
        }
    }
}

