/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.util.Iterator;
import net.minestom.server.collision.RayUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.block.BlockFace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BoundingBox
implements Shape {
    private static final BoundingBox sleepingBoundingBox = new BoundingBox(0.2, 0.2, 0.2);
    private static final BoundingBox sneakingBoundingBox = new BoundingBox(0.6, 1.5, 0.6);
    private static final BoundingBox smallBoundingBox = new BoundingBox(0.6, 0.6, 0.6);
    static final BoundingBox ZERO = new BoundingBox(0.0, 0.0, 0.0);
    private final double width;
    private final double height;
    private final double depth;
    private final Point offset;
    private Point relativeEnd;

    public BoundingBox(double width, double height, double depth, Point offset) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.offset = offset;
    }

    public BoundingBox(double width, double height, double depth) {
        this(width, height, depth, new Vec(-width / 2.0, 0.0, -depth / 2.0));
    }

    @Override
    public boolean isOccluded(@NotNull Shape shape, @NotNull BlockFace face) {
        return false;
    }

    @Override
    @ApiStatus.Experimental
    public boolean intersectBox(@NotNull Point positionRelative, @NotNull BoundingBox boundingBox) {
        return this.minX() + positionRelative.x() <= boundingBox.maxX() - 5.0E-7 && this.maxX() + positionRelative.x() >= boundingBox.minX() + 5.0E-7 && this.minY() + positionRelative.y() <= boundingBox.maxY() - 5.0E-7 && this.maxY() + positionRelative.y() >= boundingBox.minY() + 5.0E-7 && this.minZ() + positionRelative.z() <= boundingBox.maxZ() - 5.0E-7 && this.maxZ() + positionRelative.z() >= boundingBox.minZ() + 5.0E-7;
    }

    @Override
    @ApiStatus.Experimental
    public boolean intersectBoxSwept(@NotNull Point rayStart, @NotNull Point rayDirection, @NotNull Point shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        if (RayUtils.BoundingBoxIntersectionCheck(moving, rayStart, rayDirection, this, shapePos, finalResult)) {
            finalResult.collidedPosition = rayStart.add(rayDirection.mul(finalResult.res));
            finalResult.collidedShape = this;
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    public boolean boundingBoxRayIntersectionCheck(Vec start, Vec direction, Pos position) {
        return RayUtils.BoundingBoxRayIntersectionCheck(start, direction, this, position);
    }

    @Override
    @NotNull
    public Point relativeStart() {
        return this.offset;
    }

    @Override
    @NotNull
    public Point relativeEnd() {
        Point relativeEnd = this.relativeEnd;
        if (relativeEnd == null) {
            this.relativeEnd = relativeEnd = this.offset.add(this.width, this.height, this.depth);
        }
        return relativeEnd;
    }

    public String toString() {
        Object result = "BoundingBox";
        result = (String)result + "\n";
        result = (String)result + "[" + this.minX() + " : " + this.maxX() + "]";
        result = (String)result + "\n";
        result = (String)result + "[" + this.minY() + " : " + this.maxY() + "]";
        result = (String)result + "\n";
        result = (String)result + "[" + this.minZ() + " : " + this.maxZ() + "]";
        return result;
    }

    @NotNull
    public BoundingBox expand(double x, double y, double z) {
        return new BoundingBox(this.width + x, this.height + y, this.depth + z);
    }

    @NotNull
    public BoundingBox contract(double x, double y, double z) {
        return new BoundingBox(this.width - x, this.height - y, this.depth - z);
    }

    @NotNull
    public BoundingBox withOffset(Point offset) {
        return new BoundingBox(this.width, this.height, this.depth, offset);
    }

    public double width() {
        return this.width;
    }

    public double height() {
        return this.height;
    }

    public double depth() {
        return this.depth;
    }

    public double minX() {
        return this.relativeStart().x();
    }

    public double maxX() {
        return this.relativeEnd().x();
    }

    public double minY() {
        return this.relativeStart().y();
    }

    public double maxY() {
        return this.relativeEnd().y();
    }

    public double minZ() {
        return this.relativeStart().z();
    }

    public double maxZ() {
        return this.relativeEnd().z();
    }

    public Iterator<Point> getBlocks(Point point) {
        return new PointIterator(this, point, AxisMask.NONE, 0.0);
    }

    public Iterator<Point> getBlocks(Point point, AxisMask axisMask, double axis) {
        return new PointIterator(this, point, axisMask, axis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (Double.compare(that.width, this.width) != 0) {
            return false;
        }
        if (Double.compare(that.height, this.height) != 0) {
            return false;
        }
        if (Double.compare(that.depth, this.depth) != 0) {
            return false;
        }
        return this.offset.equals(that.offset);
    }

    @Nullable
    public static BoundingBox fromPose(@NotNull Entity.Pose pose) {
        return switch (pose) {
            case Entity.Pose.FALL_FLYING, Entity.Pose.SWIMMING, Entity.Pose.SPIN_ATTACK -> smallBoundingBox;
            case Entity.Pose.SLEEPING, Entity.Pose.DYING -> sleepingBoundingBox;
            case Entity.Pose.SNEAKING -> sneakingBoundingBox;
            default -> null;
        };
    }

    static class PointIterator
    implements Iterator<Point> {
        private final double sx;
        private final double sy;
        private final double sz;
        double x;
        double y;
        double z;
        private double minX;
        private double minY;
        private double minZ;
        private double maxX;
        private double maxY;
        private double maxZ;

        public PointIterator(BoundingBox boundingBox, Point p, AxisMask axisMask, double axis) {
            this.minX = (int)Math.floor(boundingBox.minX() + p.x());
            this.minY = (int)Math.floor(boundingBox.minY() + p.y());
            this.minZ = (int)Math.floor(boundingBox.minZ() + p.z());
            this.maxX = (int)Math.floor(boundingBox.maxX() + p.x());
            this.maxY = (int)Math.floor(boundingBox.maxY() + p.y());
            this.maxZ = (int)Math.floor(boundingBox.maxZ() + p.z());
            this.x = this.minX;
            this.y = this.minY;
            this.z = this.minZ;
            this.sx = boundingBox.minX() + p.x() - this.minX;
            this.sy = boundingBox.minY() + p.y() - this.minY;
            this.sz = boundingBox.minZ() + p.z() - this.minZ;
            if (axisMask == AxisMask.X) {
                this.minX = this.x = axis + p.x();
                this.maxX = this.x;
            } else if (axisMask == AxisMask.Y) {
                this.minY = this.y = axis + p.y();
                this.maxY = this.y;
            } else if (axisMask == AxisMask.Z) {
                this.minZ = this.z = axis + p.z();
                this.maxZ = this.z;
            }
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.maxX && this.y <= this.maxY && this.z <= this.maxZ;
        }

        @Override
        public Point next() {
            Vec res = new Vec(this.x + this.sx, this.y + this.sy, this.z + this.sz);
            this.x += 1.0;
            if (this.x > this.maxX) {
                this.x = this.minX;
                this.y += 1.0;
                if (this.y > this.maxY) {
                    this.y = this.minY;
                    this.z += 1.0;
                }
            }
            return res;
        }
    }

    public static enum AxisMask {
        X,
        Y,
        Z,
        NONE;

    }
}

