package net.minestom.server.recipe.display;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum SlotDisplayType implements StaticProtocolObject<SlotDisplayType> {
    EMPTY("empty"),

    ANY_FUEL("any_fuel"),

    ITEM("item"),

    ITEM_STACK("item_stack"),

    TAG("tag"),

    SMITHING_TRIM("smithing_trim"),

    WITH_REMAINDER("with_remainder"),

    COMPOSITE("composite");

    private static final Map<Key, SlotDisplayType> BY_KEY = Arrays.stream(values()).collect(Collectors.toUnmodifiableMap(SlotDisplayType::key, Function.identity()));

    public static final NetworkBuffer.Type<SlotDisplayType> NETWORK_TYPE = NetworkBuffer.Enum(SlotDisplayType.class);

    public static final Codec<SlotDisplayType> CODEC = Codec.KEY.transform(BY_KEY::get, SlotDisplayType::key);

    private final Key key;

    SlotDisplayType(@NotNull String key) {
        this.key = Key.key(key);
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
