package net.minestom.server.entity;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum VillagerType implements StaticProtocolObject<VillagerType> {
    DESERT("desert"),

    JUNGLE("jungle"),

    PLAINS("plains"),

    SAVANNA("savanna"),

    SNOW("snow"),

    SWAMP("swamp"),

    TAIGA("taiga");

    private static final Map<Key, VillagerType> BY_KEY = Arrays.stream(values()).collect(Collectors.toUnmodifiableMap(VillagerType::key, Function.identity()));

    public static final NetworkBuffer.Type<VillagerType> NETWORK_TYPE = NetworkBuffer.Enum(VillagerType.class);

    public static final Codec<VillagerType> CODEC = Codec.KEY.transform(BY_KEY::get, VillagerType::key);

    private final Key key;

    VillagerType(@NotNull String key) {
        this.key = Key.key(key);
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
