/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.util.List;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.ShapeImpl;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.other.ArmorStandMeta;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.utils.block.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BlockCollision {
    BlockCollision() {
    }

    static PhysicsResult handlePhysics(@NotNull BoundingBox boundingBox, @NotNull Vec velocity, @NotNull Pos entityPosition, @NotNull Block.Getter getter, @Nullable PhysicsResult lastPhysicsResult, boolean singleCollision) {
        if (velocity.isZero()) {
            return new PhysicsResult(entityPosition, Vec.ZERO, false, false, false, false, velocity, new Point[3], new Shape[3], new Point[3], false, SweepResult.NO_COLLISION);
        }
        PhysicsResult cachedResult = BlockCollision.cachedPhysics(velocity, entityPosition, getter, lastPhysicsResult);
        if (cachedResult != null) {
            return cachedResult;
        }
        return BlockCollision.stepPhysics(boundingBox, velocity, entityPosition, getter, singleCollision);
    }

    static Entity canPlaceBlockAt(Instance instance, Point blockPos, Block b) {
        for (Entity entity : instance.getNearbyEntities(blockPos, 3.0)) {
            boolean intersects;
            ArmorStandMeta armorStandMeta;
            EntityMeta entityMeta;
            EntityType type = entity.getEntityType();
            if (!entity.hasCollision() || type == EntityType.ITEM || type == EntityType.ARROW || (entityMeta = entity.getEntityMeta()) instanceof ArmorStandMeta && (armorStandMeta = (ArmorStandMeta)entityMeta).isMarker()) continue;
            if (entity instanceof Player) {
                if (((Player)entity).getGameMode() == GameMode.SPECTATOR) continue;
                Pos playerPos = entity.getPosition().add(entity.getPosition().sub(blockPos).mul(1.0E-7));
                intersects = b.registry().collisionShape().intersectBox(playerPos.sub(blockPos), entity.getBoundingBox());
            } else {
                intersects = b.registry().collisionShape().intersectBox(entity.getPosition().sub(blockPos), entity.getBoundingBox());
            }
            if (!intersects) continue;
            return entity;
        }
        return null;
    }

    private static PhysicsResult cachedPhysics(Vec velocity, Pos entityPosition, Block.Getter getter, PhysicsResult lastPhysicsResult) {
        Shape shape;
        if (lastPhysicsResult != null && (shape = lastPhysicsResult.collisionShapes()[1]) instanceof ShapeImpl) {
            ShapeImpl shape2 = (ShapeImpl)shape;
            Block currentBlock = getter.getBlock(lastPhysicsResult.collisionPoints()[1].sub(0.0, 1.0E-6, 0.0), Block.Getter.Condition.TYPE);
            List<BoundingBox> lastBlockBoxes = shape2.collisionBoundingBoxes();
            List<BoundingBox> currentBlockBoxes = ((ShapeImpl)currentBlock.registry().collisionShape()).collisionBoundingBoxes();
            if (lastPhysicsResult.collisionY() && velocity.y() == lastPhysicsResult.originalDelta().y() && currentBlockBoxes.equals(lastBlockBoxes) && velocity.x() == 0.0 && velocity.z() == 0.0 && entityPosition.samePoint(lastPhysicsResult.newPosition()) && !lastBlockBoxes.isEmpty()) {
                return lastPhysicsResult;
            }
        }
        return null;
    }

    private static PhysicsResult stepPhysics(@NotNull BoundingBox boundingBox, @NotNull Vec velocity, @NotNull Pos entityPosition, @NotNull Block.Getter getter, boolean singleCollision) {
        SweepResult finalResult = new SweepResult(0.999999, 0.0, 0.0, 0.0, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        boolean foundCollisionX = false;
        boolean foundCollisionY = false;
        boolean foundCollisionZ = false;
        Point[] collidedPoints = new Point[3];
        Shape[] collisionShapes = new Shape[3];
        Point[] collisionShapePositions = new Point[3];
        boolean hasCollided = false;
        Vec[] allFaces = BlockCollision.calculateFaces(velocity, boundingBox);
        PhysicsResult result = BlockCollision.computePhysics(boundingBox, velocity, entityPosition, getter, allFaces, finalResult);
        while (result.collisionX() || result.collisionY() || result.collisionZ()) {
            finalResult.normalX = 0.0;
            finalResult.normalY = 0.0;
            finalResult.normalZ = 0.0;
            if (result.collisionX()) {
                foundCollisionX = true;
                collisionShapes[0] = finalResult.collidedShape;
                collisionShapePositions[0] = new Vec(finalResult.collidedShapeX, finalResult.collidedShapeY, finalResult.collidedShapeZ);
                collidedPoints[0] = new Vec(finalResult.collidedPositionX, finalResult.collidedPositionY, finalResult.collidedPositionZ);
                hasCollided = true;
                if (singleCollision) {
                    break;
                }
            } else if (result.collisionZ()) {
                foundCollisionZ = true;
                collisionShapes[2] = finalResult.collidedShape;
                collisionShapePositions[2] = new Vec(finalResult.collidedShapeX, finalResult.collidedShapeY, finalResult.collidedShapeZ);
                collidedPoints[2] = new Vec(finalResult.collidedPositionX, finalResult.collidedPositionY, finalResult.collidedPositionZ);
                hasCollided = true;
                if (singleCollision) {
                    break;
                }
            } else if (result.collisionY()) {
                foundCollisionY = true;
                collisionShapes[1] = finalResult.collidedShape;
                collisionShapePositions[1] = new Vec(finalResult.collidedShapeX, finalResult.collidedShapeY, finalResult.collidedShapeZ);
                collidedPoints[1] = new Vec(finalResult.collidedPositionX, finalResult.collidedPositionY, finalResult.collidedPositionZ);
                hasCollided = true;
                if (singleCollision) break;
            }
            if (foundCollisionX && foundCollisionY && foundCollisionZ || result.newVelocity().isZero()) break;
            finalResult.res = 0.999999;
            result = BlockCollision.computePhysics(boundingBox, result.newVelocity(), result.newPosition(), getter, allFaces, finalResult);
        }
        finalResult.res = result.res().res;
        double newDeltaX = foundCollisionX ? 0.0 : velocity.x();
        double newDeltaY = foundCollisionY ? 0.0 : velocity.y();
        double newDeltaZ = foundCollisionZ ? 0.0 : velocity.z();
        return new PhysicsResult(result.newPosition(), new Vec(newDeltaX, newDeltaY, newDeltaZ), newDeltaY == 0.0 && velocity.y() < 0.0, foundCollisionX, foundCollisionY, foundCollisionZ, velocity, collidedPoints, collisionShapes, collisionShapePositions, hasCollided, finalResult);
    }

    private static PhysicsResult computePhysics(@NotNull BoundingBox boundingBox, @NotNull Vec velocity, Pos entityPosition, @NotNull Block.Getter getter, @NotNull Vec[] allFaces, @NotNull SweepResult finalResult) {
        if (velocity.length() <= 1.0 || BlockCollision.isDiagonal(velocity)) {
            BlockCollision.fastPhysics(boundingBox, velocity, entityPosition, getter, allFaces, finalResult);
        } else {
            BlockCollision.slowPhysics(boundingBox, velocity, entityPosition, getter, allFaces, finalResult);
        }
        boolean collisionX = finalResult.normalX != 0.0;
        boolean collisionY = finalResult.normalY != 0.0;
        boolean collisionZ = finalResult.normalZ != 0.0;
        double deltaX = finalResult.res * velocity.x();
        double deltaY = finalResult.res * velocity.y();
        double deltaZ = finalResult.res * velocity.z();
        if (Math.abs(deltaX) < 1.0E-6) {
            deltaX = 0.0;
        }
        if (Math.abs(deltaY) < 1.0E-6) {
            deltaY = 0.0;
        }
        if (Math.abs(deltaZ) < 1.0E-6) {
            deltaZ = 0.0;
        }
        Pos finalPos = entityPosition.add(deltaX, deltaY, deltaZ);
        double remainingX = collisionX ? 0.0 : velocity.x() - deltaX;
        double remainingY = collisionY ? 0.0 : velocity.y() - deltaY;
        double remainingZ = collisionZ ? 0.0 : velocity.z() - deltaZ;
        return new PhysicsResult(finalPos, new Vec(remainingX, remainingY, remainingZ), collisionY, collisionX, collisionY, collisionZ, Vec.ZERO, null, null, null, false, finalResult);
    }

    private static boolean isDiagonal(Vec velocity) {
        return Math.abs(velocity.x()) == 1.0 && Math.abs(velocity.z()) == 1.0;
    }

    private static void slowPhysics(@NotNull BoundingBox boundingBox, @NotNull Vec velocity, Pos entityPosition, @NotNull Block.Getter getter, @NotNull Vec[] allFaces, @NotNull SweepResult finalResult) {
        BlockIterator iterator = new BlockIterator();
        for (Vec point : allFaces) {
            iterator.reset(Vec.fromPoint(point.add(entityPosition)), velocity, 0.0, velocity.length(), false);
            for (int timer = -1; iterator.hasNext() && timer != 0; --timer) {
                Point p = iterator.next();
                if (!BlockCollision.checkBoundingBox(p.blockX(), p.blockY(), p.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult)) continue;
                timer = 3;
            }
        }
    }

    private static void fastPhysics(@NotNull BoundingBox boundingBox, @NotNull Vec velocity, Pos entityPosition, @NotNull Block.Getter getter, @NotNull Vec[] allFaces, @NotNull SweepResult finalResult) {
        for (Vec point : allFaces) {
            Vec pointBefore = point.add(entityPosition);
            Vec pointAfter = point.add(entityPosition).add(velocity);
            boolean needsX = pointBefore.x() != pointAfter.x();
            boolean needsY = pointBefore.y() != pointAfter.y();
            boolean needsZ = pointBefore.z() != pointAfter.z();
            BlockCollision.checkBoundingBox(pointBefore.blockX(), pointBefore.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
            if (needsX && needsY && needsZ) {
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointAfter.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointAfter.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointBefore.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointAfter.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointBefore.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointAfter.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointBefore.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsX && needsY) {
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointAfter.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointBefore.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointAfter.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsX && needsZ) {
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointBefore.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointBefore.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointBefore.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsY && needsZ) {
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointAfter.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointAfter.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointBefore.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsX) {
                BlockCollision.checkBoundingBox(pointAfter.blockX(), pointBefore.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsY) {
                BlockCollision.checkBoundingBox(pointBefore.blockX(), pointAfter.blockY(), pointBefore.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (!needsZ) continue;
            BlockCollision.checkBoundingBox(pointBefore.blockX(), pointBefore.blockY(), pointAfter.blockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
        }
    }

    static boolean checkBoundingBox(int blockX, int blockY, int blockZ, Vec entityVelocity, Pos entityPosition, BoundingBox boundingBox, Block.Getter getter, SweepResult finalResult) {
        boolean currentShort;
        Block currentBlock = getter.getBlock(blockX, blockY, blockZ, Block.Getter.Condition.TYPE);
        Shape currentShape = currentBlock.registry().collisionShape();
        boolean currentCollidable = !currentShape.relativeEnd().isZero();
        boolean bl = currentShort = currentShape.relativeEnd().y() < 0.5;
        if (currentShort && BlockCollision.shouldCheckLower(entityVelocity, entityPosition, blockX, blockY, blockZ)) {
            Vec belowPos = new Vec(blockX, blockY - 1, blockZ);
            Block belowBlock = getter.getBlock(belowPos, Block.Getter.Condition.TYPE);
            Shape belowShape = belowBlock.registry().collisionShape();
            Vec currentPos = new Vec(blockX, blockY, blockZ);
            if (belowShape.relativeEnd().y() > 1.0) {
                return belowShape.intersectBoxSwept(entityPosition, entityVelocity, belowPos, boundingBox, finalResult) | (currentCollidable && currentShape.intersectBoxSwept(entityPosition, entityVelocity, currentPos, boundingBox, finalResult));
            }
            return currentCollidable && currentShape.intersectBoxSwept(entityPosition, entityVelocity, currentPos, boundingBox, finalResult);
        }
        if (currentCollidable && currentShape.intersectBoxSwept(entityPosition, entityVelocity, new Vec(blockX, blockY, blockZ), boundingBox, finalResult)) {
            Vec belowPos;
            Block belowBlock;
            Shape belowShape;
            if (currentShort && (belowShape = (belowBlock = getter.getBlock(belowPos = new Vec(blockX, blockY - 1, blockZ), Block.Getter.Condition.TYPE)).registry().collisionShape()).relativeEnd().y() > 1.0) {
                belowShape.intersectBoxSwept(entityPosition, entityVelocity, belowPos, boundingBox, finalResult);
            }
            return true;
        }
        return false;
    }

    private static boolean shouldCheckLower(Vec entityVelocity, Pos entityPosition, int blockX, int blockY, int blockZ) {
        double yVelocity = entityVelocity.y();
        if (yVelocity == 0.0) {
            return Math.floor(entityPosition.y()) == (double)blockY;
        }
        double xVelocity = entityVelocity.x();
        double zVelocity = entityVelocity.z();
        if (xVelocity == 0.0 && zVelocity == 0.0) {
            return yVelocity < 0.0 && (double)blockY == Math.floor(entityPosition.y() + yVelocity);
        }
        boolean underYX = xVelocity != 0.0 && BlockCollision.computeHeight(yVelocity, xVelocity, entityPosition.y(), entityPosition.x(), blockX) >= (double)blockY;
        boolean underYZ = zVelocity != 0.0 && BlockCollision.computeHeight(yVelocity, zVelocity, entityPosition.y(), entityPosition.z(), blockZ) >= (double)blockY;
        return underYX && underYZ;
    }

    private static double computeHeight(double yVelocity, double velocity, double entityY, double pos, int blockPos) {
        double m = yVelocity / velocity;
        return m * ((double)blockPos - pos + (double)(m > 0.0 ? 1 : 0)) + entityY;
    }

    private static Vec[] calculateFaces(Vec queryVec, BoundingBox boundingBox) {
        int queryX = (int)Math.signum(queryVec.x());
        int queryY = (int)Math.signum(queryVec.y());
        int queryZ = (int)Math.signum(queryVec.z());
        int ceilWidth = (int)Math.ceil(boundingBox.width());
        int ceilHeight = (int)Math.ceil(boundingBox.height());
        int ceilDepth = (int)Math.ceil(boundingBox.depth());
        int ceilX = ceilWidth + 1;
        int ceilY = ceilHeight + 1;
        int ceilZ = ceilDepth + 1;
        int pointCount = 0;
        if (queryX != 0) {
            pointCount += ceilY * ceilZ;
        }
        if (queryY != 0) {
            pointCount += ceilX * ceilZ;
        }
        if (queryZ != 0) {
            pointCount += ceilX * ceilY;
        }
        if (queryX != 0 && queryY != 0 && queryZ != 0) {
            pointCount -= ceilX + ceilY + ceilZ;
            ++pointCount;
        } else if (queryX != 0 && queryY != 0) {
            pointCount -= ceilZ;
        } else if (queryY != 0 && queryZ != 0) {
            pointCount -= ceilX;
        } else if (queryX != 0 && queryZ != 0) {
            pointCount -= ceilY;
        }
        Vec[] facePoints = new Vec[pointCount];
        int insertIndex = 0;
        if (queryX != 0) {
            int startIOffset = 0;
            int endIOffset = 0;
            int startJOffset = 0;
            int endJOffset = 0;
            if (queryY < 0) {
                startJOffset = 1;
            }
            if (queryY > 0) {
                endJOffset = 1;
            }
            if (queryZ < 0) {
                startIOffset = 1;
            }
            if (queryZ > 0) {
                endIOffset = 1;
            }
            for (int i = startIOffset; i <= ceilDepth - endIOffset; ++i) {
                for (int j = startJOffset; j <= ceilHeight - endJOffset; ++j) {
                    double cellK;
                    double cellI = i;
                    double cellJ = j;
                    double d = cellK = queryX < 0 ? 0.0 : boundingBox.width();
                    if ((double)i >= boundingBox.depth()) {
                        cellI = boundingBox.depth();
                    }
                    if ((double)j >= boundingBox.height()) {
                        cellJ = boundingBox.height();
                    }
                    facePoints[insertIndex++] = new Vec(cellK += boundingBox.minX(), cellJ += boundingBox.minY(), cellI += boundingBox.minZ());
                }
            }
        }
        if (queryY != 0) {
            int startJOffset = 0;
            int endJOffset = 0;
            if (queryZ < 0) {
                startJOffset = 1;
            }
            if (queryZ > 0) {
                endJOffset = 1;
            }
            for (int i = startJOffset; i <= ceilDepth - endJOffset; ++i) {
                for (int j = 0; j <= ceilWidth; ++j) {
                    double cellK;
                    double cellI = i;
                    double cellJ = j;
                    double d = cellK = queryY < 0 ? 0.0 : boundingBox.height();
                    if ((double)i >= boundingBox.depth()) {
                        cellI = boundingBox.depth();
                    }
                    if ((double)j >= boundingBox.width()) {
                        cellJ = boundingBox.width();
                    }
                    facePoints[insertIndex++] = new Vec(cellJ += boundingBox.minX(), cellK += boundingBox.minY(), cellI += boundingBox.minZ());
                }
            }
        }
        if (queryZ != 0) {
            for (int i = 0; i <= ceilHeight; ++i) {
                for (int j = 0; j <= ceilWidth; ++j) {
                    double cellK;
                    double cellI = i;
                    double cellJ = j;
                    double d = cellK = queryZ < 0 ? 0.0 : boundingBox.depth();
                    if ((double)i >= boundingBox.height()) {
                        cellI = boundingBox.height();
                    }
                    if ((double)j >= boundingBox.width()) {
                        cellJ = boundingBox.width();
                    }
                    facePoints[insertIndex++] = new Vec(cellJ += boundingBox.minX(), cellI += boundingBox.minY(), cellK += boundingBox.minZ());
                }
            }
        }
        return facePoints;
    }
}

