/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import java.util.Arrays;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.MathUtils;

public final class Palettes {
    private Palettes() {
    }

    public static long[] pack(int[] ints, int bitsPerEntry) {
        int intsPerLong = (int)Math.floor(64.0 / (double)bitsPerEntry);
        long[] longs = new long[(int)Math.ceil((double)ints.length / (double)intsPerLong)];
        long mask = (1L << bitsPerEntry) - 1L;
        for (int i = 0; i < longs.length; ++i) {
            for (int intIndex = 0; intIndex < intsPerLong; ++intIndex) {
                int bitIndex = intIndex * bitsPerEntry;
                int intActualIndex = intIndex + i * intsPerLong;
                if (intActualIndex >= ints.length) continue;
                int n = i;
                longs[n] = longs[n] | ((long)ints[intActualIndex] & mask) << bitIndex;
            }
        }
        return longs;
    }

    public static void unpack(int[] out, long[] in, int bitsPerEntry) {
        assert (in.length != 0) : "unpack input array is zero";
        double intsPerLong = Math.floor(64.0 / (double)bitsPerEntry);
        int intsPerLongCeil = (int)Math.ceil(intsPerLong);
        long mask = (1L << bitsPerEntry) - 1L;
        for (int i = 0; i < out.length; ++i) {
            int longIndex = i / intsPerLongCeil;
            int subIndex = i % intsPerLongCeil;
            out[i] = (int)(in[longIndex] >>> bitsPerEntry * subIndex & mask);
        }
    }

    public static int maxPaletteSize(int bitsPerEntry) {
        return 1 << bitsPerEntry;
    }

    public static int arrayLength(int dimension, int bitsPerEntry) {
        int elementCount = dimension * dimension * dimension;
        int valuesPerLong = 64 / bitsPerEntry;
        return (elementCount + valuesPerLong - 1) / valuesPerLong;
    }

    public static int read(int dimension, int bitsPerEntry, long[] values, int x, int y, int z) {
        int sectionIndex = Palettes.sectionIndex(dimension, x, y, z);
        int valuesPerLong = 64 / bitsPerEntry;
        int index = sectionIndex / valuesPerLong;
        int bitIndex = (sectionIndex - index * valuesPerLong) * bitsPerEntry;
        int mask = (1 << bitsPerEntry) - 1;
        return (int)(values[index] >> bitIndex) & mask;
    }

    public static int write(int dimension, int bitsPerEntry, long[] values, int x, int y, int z, int value) {
        int valuesPerLong = 64 / bitsPerEntry;
        int sectionIndex = Palettes.sectionIndex(dimension, x, y, z);
        int index = sectionIndex / valuesPerLong;
        int bitIndex = (sectionIndex - index * valuesPerLong) * bitsPerEntry;
        long block = values[index];
        long clear = (1L << bitsPerEntry) - 1L;
        long oldBlock = block >> bitIndex & clear;
        values[index] = block & (clear << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << bitIndex;
        return (int)oldBlock;
    }

    public static void fill(int bitsPerEntry, long[] values, int value) {
        int valuesPerLong = 64 / bitsPerEntry;
        long block = 0L;
        for (int i = 0; i < valuesPerLong; ++i) {
            block |= (long)value << i * bitsPerEntry;
        }
        Arrays.fill(values, block);
    }

    public static int count(int bitsPerEntry, long[] values) {
        int valuesPerLong = 64 / bitsPerEntry;
        int count = 0;
        for (long block : values) {
            for (int i = 0; i < valuesPerLong; ++i) {
                count += (int)(block >>> i * bitsPerEntry & (long)((1 << bitsPerEntry) - 1));
            }
        }
        return count;
    }

    public static int sectionIndex(int dimension, int x, int y, int z) {
        int dimensionBitCount = MathUtils.bitsToRepresent(dimension - 1);
        return y << (dimensionBitCount << 1) | z << dimensionBitCount | x;
    }

    public static void getAllFill(byte dimension, int value, Palette.EntryConsumer consumer) {
        for (byte y = 0; y < dimension; y = (byte)(y + 1)) {
            for (byte z = 0; z < dimension; z = (byte)(z + 1)) {
                for (byte x = 0; x < dimension; x = (byte)(x + 1)) {
                    consumer.accept(x, y, z, value);
                }
            }
        }
    }
}

