/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.instance.palette.Palettes;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PaletteImpl
implements Palette {
    private static final ThreadLocal<int[]> WRITE_CACHE = ThreadLocal.withInitial(() -> new int[4096]);
    final byte dimension;
    final byte minBitsPerEntry;
    final byte maxBitsPerEntry;
    final byte directBits;
    byte bitsPerEntry = 0;
    int count = 0;
    long[] values;
    IntArrayList paletteToValueList;
    private Int2IntOpenHashMap valueToPaletteMap;

    PaletteImpl(byte dimension, byte minBitsPerEntry, byte maxBitsPerEntry, byte directBits) {
        PaletteImpl.validateDimension(dimension);
        this.dimension = dimension;
        this.minBitsPerEntry = minBitsPerEntry;
        this.maxBitsPerEntry = maxBitsPerEntry;
        this.directBits = directBits;
    }

    PaletteImpl(byte dimension, byte minBitsPerEntry, byte maxBitsPerEntry, byte directBits, byte bitsPerEntry, int count, int[] palette, long[] values) {
        this(dimension, minBitsPerEntry, maxBitsPerEntry, directBits);
        this.bitsPerEntry = bitsPerEntry;
        this.count = count;
        this.values = values;
        if (this.hasPalette()) {
            this.paletteToValueList = new IntArrayList(palette);
            this.valueToPaletteMap = new Int2IntOpenHashMap(palette.length);
            this.valueToPaletteMap.defaultReturnValue(-1);
            for (int i = 0; i < palette.length; ++i) {
                this.valueToPaletteMap.put(palette[i], i);
            }
        }
    }

    PaletteImpl(byte dimension, byte minBitsPerEntry, byte maxBitsPerEntry, byte directBits, byte bitsPerEntry) {
        this(dimension, minBitsPerEntry, maxBitsPerEntry, directBits, bitsPerEntry, 0, new int[]{0}, new long[Palettes.arrayLength(dimension, bitsPerEntry)]);
    }

    @Override
    public int get(int x, int y, int z) {
        PaletteImpl.validateCoord(this.dimension, x, y, z);
        if (this.bitsPerEntry == 0) {
            return this.count;
        }
        int value = Palettes.read(this.dimension(), this.bitsPerEntry, this.values, x, y, z);
        return this.paletteIndexToValue(value);
    }

    @Override
    public void getAll(@NotNull Palette.EntryConsumer consumer) {
        if (this.bitsPerEntry == 0) {
            Palettes.getAllFill(this.dimension, this.count, consumer);
        } else {
            this.retrieveAll(consumer, true);
        }
    }

    @Override
    public void getAllPresent(@NotNull Palette.EntryConsumer consumer) {
        if (this.bitsPerEntry == 0) {
            if (this.count != 0) {
                Palettes.getAllFill(this.dimension, this.count, consumer);
            }
        } else {
            this.retrieveAll(consumer, false);
        }
    }

    @Override
    public void set(int x, int y, int z, int value) {
        PaletteImpl.validateCoord(this.dimension, x, y, z);
        value = this.valueToPaletteIndex(value);
        int oldValue = Palettes.write(this.dimension(), this.bitsPerEntry, this.values, x, y, z, value);
        boolean currentAir = oldValue == 0;
        if (currentAir != (value == 0)) {
            this.count += currentAir ? 1 : -1;
        }
    }

    @Override
    public void fill(int value) {
        this.bitsPerEntry = 0;
        this.count = value;
        this.values = null;
        this.paletteToValueList = null;
        this.valueToPaletteMap = null;
    }

    @Override
    public void setAll(@NotNull Palette.EntrySupplier supplier) {
        int[] cache = WRITE_CACHE.get();
        int dimension = this.dimension();
        int fillValue = -1;
        int count = 0;
        int index = 0;
        for (int y = 0; y < dimension; ++y) {
            for (int z = 0; z < dimension; ++z) {
                for (int x = 0; x < dimension; ++x) {
                    int value = supplier.get(x, y, z);
                    if (fillValue != -2) {
                        if (fillValue == -1) {
                            fillValue = value;
                        } else if (fillValue != value) {
                            fillValue = -2;
                        }
                    }
                    if (value != 0) {
                        value = this.valueToPaletteIndex(value);
                        ++count;
                    }
                    cache[index++] = value;
                }
            }
        }
        assert (index == this.maxSize());
        if (fillValue < 0) {
            this.updateAll(cache);
            this.count = count;
        } else {
            this.fill(fillValue);
        }
    }

    @Override
    public void replace(int x, int y, int z, @NotNull IntUnaryOperator operator) {
        PaletteImpl.validateCoord(this.dimension, x, y, z);
        int oldValue = this.get(x, y, z);
        int newValue = operator.applyAsInt(oldValue);
        if (oldValue != newValue) {
            this.set(x, y, z, newValue);
        }
    }

    @Override
    public void replaceAll(@NotNull Palette.EntryFunction function) {
        int[] cache = WRITE_CACHE.get();
        AtomicInteger arrayIndex = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        this.getAll((x, y, z, value) -> {
            int newValue = function.apply(x, y, z, value);
            int index = arrayIndex.getPlain();
            arrayIndex.setPlain(index + 1);
            int n = cache[index] = newValue != value ? this.valueToPaletteIndex(newValue) : value;
            if (newValue != 0) {
                count.setPlain(count.getPlain() + 1);
            }
        });
        assert (arrayIndex.getPlain() == this.maxSize());
        this.updateAll(cache);
        this.count = count.getPlain();
    }

    @Override
    public int count() {
        if (this.bitsPerEntry == 0) {
            return this.count == 0 ? 0 : this.maxSize();
        }
        return this.count;
    }

    @Override
    public int bitsPerEntry() {
        return this.bitsPerEntry;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public void optimize(Palette.Optimization focus) {
        byte optimalBits;
        byte bitsPerEntry = this.bitsPerEntry;
        if (bitsPerEntry == 0) {
            return;
        }
        IntOpenHashSet uniqueValues = new IntOpenHashSet();
        this.getAll((arg_0, arg_1, arg_2, arg_3) -> PaletteImpl.lambda$optimize$2((IntSet)uniqueValues, arg_0, arg_1, arg_2, arg_3));
        int uniqueCount = uniqueValues.size();
        if (uniqueCount == 1) {
            this.fill(uniqueValues.iterator().nextInt());
            return;
        }
        if (focus == Palette.Optimization.SPEED) {
            this.resize(this.directBits);
        } else if (focus == Palette.Optimization.SIZE && (optimalBits = (byte)MathUtils.bitsToRepresent(uniqueCount - 1)) < bitsPerEntry) {
            this.resize(optimalBits);
        }
    }

    @Override
    public boolean compare(@NotNull Palette p) {
        PaletteImpl palette = (PaletteImpl)p;
        int dimension = this.dimension();
        if (palette.dimension() != dimension) {
            return false;
        }
        if (palette.count == 0 && this.count == 0) {
            return true;
        }
        if (palette.bitsPerEntry == 0 && this.bitsPerEntry == 0 && palette.count == this.count) {
            return true;
        }
        for (int y = 0; y < dimension; ++y) {
            for (int z = 0; z < dimension; ++z) {
                for (int x = 0; x < dimension; ++x) {
                    int value2;
                    int value1 = this.get(x, y, z);
                    if (value1 == (value2 = palette.get(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Palette clone() {
        PaletteImpl clone = new PaletteImpl(this.dimension, this.minBitsPerEntry, this.maxBitsPerEntry, this.directBits);
        clone.bitsPerEntry = this.bitsPerEntry;
        clone.count = this.count;
        if (this.bitsPerEntry == 0) {
            return clone;
        }
        clone.values = (long[])this.values.clone();
        if (this.hasPalette()) {
            clone.paletteToValueList = new IntArrayList((IntList)this.paletteToValueList);
            clone.valueToPaletteMap = new Int2IntOpenHashMap((Int2IntMap)this.valueToPaletteMap);
        }
        return clone;
    }

    private void retrieveAll(@NotNull Palette.EntryConsumer consumer, boolean consumeEmpty) {
        if (!consumeEmpty && this.count == 0) {
            return;
        }
        long[] values = this.values;
        int dimension = this.dimension();
        byte bitsPerEntry = this.bitsPerEntry;
        int magicMask = (1 << bitsPerEntry) - 1;
        int valuesPerLong = 64 / bitsPerEntry;
        int size = this.maxSize();
        int dimensionMinus = dimension - 1;
        int[] ids = this.hasPalette() ? this.paletteToValueList.elements() : null;
        int dimensionBitCount = MathUtils.bitsToRepresent(dimensionMinus);
        int shiftedDimensionBitCount = dimensionBitCount << 1;
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                int paletteIndex = (int)(value >> bitIndex & (long)magicMask);
                if (!consumeEmpty && paletteIndex == 0) continue;
                int y = index >> shiftedDimensionBitCount;
                int z = index >> dimensionBitCount & dimensionMinus;
                int x = index & dimensionMinus;
                int result = ids != null && paletteIndex < ids.length ? ids[paletteIndex] : paletteIndex;
                consumer.accept(x, y, z, result);
            }
        }
    }

    private void updateAll(int[] paletteValues) {
        int size = this.maxSize();
        assert (paletteValues.length >= size);
        byte bitsPerEntry = this.bitsPerEntry;
        int valuesPerLong = 64 / bitsPerEntry;
        long clear = (1L << bitsPerEntry) - 1L;
        long[] values = this.values;
        for (int i = 0; i < values.length; ++i) {
            long block = values[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                block = block & (clear << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (long)paletteValues[index] << bitIndex;
            }
            values[i] = block;
        }
    }

    void resize(byte newBitsPerEntry) {
        if (newBitsPerEntry > this.maxBitsPerEntry) {
            newBitsPerEntry = this.directBits;
        }
        PaletteImpl palette = new PaletteImpl(this.dimension, this.minBitsPerEntry, this.maxBitsPerEntry, this.directBits, newBitsPerEntry);
        if (this.paletteToValueList != null) {
            palette.paletteToValueList = this.paletteToValueList;
        }
        if (this.valueToPaletteMap != null) {
            palette.valueToPaletteMap = this.valueToPaletteMap;
        }
        this.getAll(palette::set);
        this.bitsPerEntry = palette.bitsPerEntry;
        this.values = palette.values;
        this.paletteToValueList = palette.paletteToValueList;
        this.valueToPaletteMap = palette.valueToPaletteMap;
        assert (this.values != null);
    }

    @Override
    public int paletteIndexToValue(int value) {
        return this.hasPalette() ? this.paletteToValueList.elements()[value] : value;
    }

    @Override
    public int valueToPaletteIndex(int value) {
        byte bpe;
        int lastPaletteIndex;
        if (!this.hasPalette()) {
            return value;
        }
        if (this.values == null) {
            this.resize(this.minBitsPerEntry);
        }
        if ((lastPaletteIndex = this.paletteToValueList.size()) >= Palettes.maxPaletteSize(bpe = this.bitsPerEntry)) {
            this.resize((byte)(bpe + 1));
            return this.valueToPaletteIndex(value);
        }
        int lookup = this.valueToPaletteMap.putIfAbsent(value, lastPaletteIndex);
        if (lookup != -1) {
            return lookup;
        }
        this.paletteToValueList.add(value);
        assert (lastPaletteIndex < Palettes.maxPaletteSize(bpe));
        return lastPaletteIndex;
    }

    @Override
    public int singleValue() {
        return this.bitsPerEntry == 0 ? this.count : -1;
    }

    @Override
    public long @Nullable [] indexedValues() {
        return this.values;
    }

    boolean hasPalette() {
        return this.bitsPerEntry <= this.maxBitsPerEntry;
    }

    private static void validateCoord(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            throw new IllegalArgumentException("Coordinates must be non-negative");
        }
        if (x >= dimension || y >= dimension || z >= dimension) {
            throw new IllegalArgumentException("Coordinates must be less than the dimension size, got " + x + ", " + y + ", " + z + " for dimension " + dimension);
        }
    }

    private static void validateDimension(int dimension) {
        if (dimension <= 1 || (dimension & dimension - 1) != 0) {
            throw new IllegalArgumentException("Dimension must be a positive power of 2, got " + dimension);
        }
    }

    private static /* synthetic */ void lambda$optimize$2(IntSet uniqueValues, int x, int y, int z, int value) {
        uniqueValues.add(value);
    }
}

