/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import java.util.function.IntUnaryOperator;
import net.minestom.server.instance.palette.PaletteImpl;
import net.minestom.server.instance.palette.Palettes;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Palette
permits PaletteImpl {
    public static final int BLOCK_DIMENSION = 16;
    public static final int BLOCK_PALETTE_MIN_BITS = 4;
    public static final int BLOCK_PALETTE_MAX_BITS = 8;
    public static final int BLOCK_PALETTE_DIRECT_BITS = 15;
    public static final int BIOME_DIMENSION = 4;
    public static final int BIOME_PALETTE_MIN_BITS = 1;
    public static final int BIOME_PALETTE_MAX_BITS = 3;
    @ApiStatus.Internal
    public static final int BIOME_PALETTE_DIRECT_BITS = 6;
    public static final NetworkBuffer.Type<Palette> BLOCK_SERIALIZER = Palette.serializer(16, 4, 8, 15);

    public static Palette blocks(int bitsPerEntry) {
        return Palette.sized(16, 4, 8, 15, bitsPerEntry);
    }

    public static Palette biomes(int bitsPerEntry) {
        return Palette.sized(4, 1, 3, 6, bitsPerEntry);
    }

    public static Palette blocks() {
        return Palette.empty(16, 4, 8, 15);
    }

    public static Palette biomes() {
        return Palette.empty(4, 1, 3, 6);
    }

    public static Palette empty(int dimension, int minBitsPerEntry, int maxBitsPerEntry, int directBits) {
        return new PaletteImpl((byte)dimension, (byte)minBitsPerEntry, (byte)maxBitsPerEntry, (byte)directBits);
    }

    public static Palette sized(int dimension, int minBitsPerEntry, int maxBitsPerEntry, int directBits, int bitsPerEntry) {
        return new PaletteImpl((byte)dimension, (byte)minBitsPerEntry, (byte)maxBitsPerEntry, (byte)directBits, (byte)bitsPerEntry);
    }

    public int get(int var1, int var2, int var3);

    public void getAll(@NotNull EntryConsumer var1);

    public void getAllPresent(@NotNull EntryConsumer var1);

    public void set(int var1, int var2, int var3, int var4);

    public void fill(int var1);

    public void setAll(@NotNull EntrySupplier var1);

    public void replace(int var1, int var2, int var3, @NotNull IntUnaryOperator var4);

    public void replaceAll(@NotNull EntryFunction var1);

    public int count();

    public int bitsPerEntry();

    public int dimension();

    default public int maxSize() {
        int dimension = this.dimension();
        return dimension * dimension * dimension;
    }

    public void optimize(Optimization var1);

    public boolean compare(@NotNull Palette var1);

    @NotNull
    public Palette clone();

    @ApiStatus.Internal
    public int paletteIndexToValue(int var1);

    @ApiStatus.Internal
    public int valueToPaletteIndex(int var1);

    @ApiStatus.Internal
    public int singleValue();

    @ApiStatus.Internal
    public long @Nullable [] indexedValues();

    public static NetworkBuffer.Type<Palette> biomeSerializer(int biomeCount) {
        int directBits = MathUtils.bitsToRepresent(biomeCount);
        return Palette.serializer(4, 1, 3, directBits);
    }

    public static NetworkBuffer.Type<Palette> serializer(final int dimension, final int minIndirect, final int maxIndirect, final int directBits) {
        return new NetworkBuffer.Type<PaletteImpl>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, PaletteImpl value) {
                if (directBits != value.directBits && !value.hasPalette()) {
                    PaletteImpl tmp = new PaletteImpl((byte)dimension, (byte)minIndirect, (byte)maxIndirect, (byte)directBits);
                    tmp.setAll(value::get);
                    value = tmp;
                }
                byte bitsPerEntry = value.bitsPerEntry;
                buffer.write(NetworkBuffer.BYTE, bitsPerEntry);
                if (bitsPerEntry == 0) {
                    buffer.write(NetworkBuffer.VAR_INT, value.count);
                } else {
                    if (value.hasPalette()) {
                        buffer.write(NetworkBuffer.VAR_INT.list(), value.paletteToValueList);
                    }
                    for (long l : value.values) {
                        buffer.write(NetworkBuffer.LONG, l);
                    }
                }
            }

            @Override
            public PaletteImpl read(@NotNull NetworkBuffer buffer) {
                byte bitsPerEntry = buffer.read(NetworkBuffer.BYTE);
                if (bitsPerEntry == 0) {
                    int value = buffer.read(NetworkBuffer.VAR_INT);
                    PaletteImpl palette = new PaletteImpl((byte)dimension, (byte)minIndirect, (byte)maxIndirect, (byte)directBits);
                    palette.count = value;
                    return palette;
                }
                if (bitsPerEntry >= minIndirect && bitsPerEntry <= maxIndirect) {
                    int[] palette = buffer.read(NetworkBuffer.VAR_INT_ARRAY);
                    int entriesPerLong = 64 / bitsPerEntry;
                    long[] data = new long[dimension * dimension * dimension / entriesPerLong + 1];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = buffer.read(NetworkBuffer.LONG);
                    }
                    return new PaletteImpl((byte)dimension, (byte)minIndirect, (byte)maxIndirect, (byte)directBits, bitsPerEntry, Palettes.count(bitsPerEntry, data), palette, data);
                }
                int length = Palettes.arrayLength(dimension, bitsPerEntry);
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = buffer.read(NetworkBuffer.LONG);
                }
                return new PaletteImpl((byte)dimension, (byte)minIndirect, (byte)maxIndirect, (byte)directBits, bitsPerEntry, Palettes.count(bitsPerEntry, data), new int[0], data);
            }
        };
    }

    @FunctionalInterface
    public static interface EntryFunction {
        public int apply(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface EntrySupplier {
        public int get(int var1, int var2, int var3);
    }

    public static enum Optimization {
        SIZE,
        SPEED;

    }
}

