/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

final class BlockImpl
extends Record
implements Block {
    @NotNull
    private final RegistryData.BlockEntry registry;
    private final long propertiesArray;
    @Nullable
    private final CompoundBinaryTag nbt;
    @Nullable
    private final BlockHandler handler;
    private static final int BITS_PER_INDEX = 5;
    private static final int MAX_STATES = 12;
    private static final int MAX_VALUES = 32;
    private static final List<Block> BLOCK_STATE_MAP;
    private static final List<PropertyType[]> PROPERTIES_TYPE;
    private static final List<Long2ObjectArrayMap<BlockImpl>> POSSIBLE_STATES;
    static final Registry<Block> REGISTRY;

    BlockImpl(@NotNull RegistryData.BlockEntry registry, long propertiesArray, @Nullable CompoundBinaryTag nbt, @Nullable BlockHandler handler) {
        this.registry = registry;
        this.propertiesArray = propertiesArray;
        this.nbt = nbt;
        this.handler = handler;
    }

    static @UnknownNullability Block get(@NotNull String key) {
        return REGISTRY.get(Key.key((String)key));
    }

    static Block getState(int stateId) {
        return BLOCK_STATE_MAP.get(stateId);
    }

    @Nullable
    static Block parseState(@NotNull String input) {
        if (input.isEmpty()) {
            return null;
        }
        int nbtIndex = input.indexOf("[");
        if (nbtIndex == 0) {
            return null;
        }
        if (nbtIndex == -1) {
            return Block.fromKey(input);
        }
        if (!input.endsWith("]")) {
            return null;
        }
        String blockName = input.substring(0, nbtIndex);
        Block block = Block.fromKey(blockName);
        if (block == null) {
            return null;
        }
        String query = input.substring(nbtIndex);
        Map<String, String> propertyMap = BlockUtils.parseProperties(query);
        try {
            return block.withProperties(propertyMap);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public Block withProperty(@NotNull String property, @NotNull String value) {
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        byte keyIndex = BlockImpl.findKeyIndexThrow(propertyTypes, property, this);
        byte valueIndex = BlockImpl.findValueIndexThrow(propertyTypes[keyIndex], value, this);
        long updatedProperties = BlockImpl.updateIndex(this.propertiesArray, keyIndex, valueIndex);
        return this.compute(updatedProperties);
    }

    @Override
    @NotNull
    public Block withProperties(@NotNull @NotNull Map<@NotNull String, @NotNull String> properties) {
        if (properties.isEmpty()) {
            return this;
        }
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        long updatedProperties = this.propertiesArray;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            byte keyIndex = BlockImpl.findKeyIndexThrow(propertyTypes, entry.getKey(), this);
            byte valueIndex = BlockImpl.findValueIndexThrow(propertyTypes[keyIndex], entry.getValue(), this);
            updatedProperties = BlockImpl.updateIndex(updatedProperties, keyIndex, valueIndex);
        }
        return this.compute(updatedProperties);
    }

    @Override
    @NotNull
    public <T> Block withTag(@NotNull Tag<T> tag, @Nullable T value) {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        if (this.nbt != null) {
            builder.put(this.nbt);
        }
        tag.write(builder, value);
        CompoundBinaryTag temporaryNbt = builder.build();
        CompoundBinaryTag finalNbt = temporaryNbt.size() > 0 ? temporaryNbt : null;
        return new BlockImpl(this.registry, this.propertiesArray, finalNbt, this.handler);
    }

    @Override
    @NotNull
    public Block withNbt(@Nullable CompoundBinaryTag compound) {
        return new BlockImpl(this.registry, this.propertiesArray, compound, this.handler);
    }

    @Override
    @NotNull
    public Block withHandler(@Nullable BlockHandler handler) {
        return new BlockImpl(this.registry, this.propertiesArray, this.nbt, handler);
    }

    @Override
    public @Unmodifiable @NotNull Map<String, String> properties() {
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        int length = propertyTypes.length;
        if (length == 0) {
            return Map.of();
        }
        Object[] keys = new String[length];
        Object[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            PropertyType property = propertyTypes[i];
            keys[i] = property.key();
            long index = BlockImpl.extractIndex(this.propertiesArray, i);
            values[i] = property.values().get((int)index);
        }
        return Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectArrayMap(keys, values, length));
    }

    @Override
    @NotNull
    public String state() {
        Map<String, String> properties = this.properties();
        if (properties.isEmpty()) {
            return this.name();
        }
        StringBuilder builder = new StringBuilder(this.name()).append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    @NotNull
    public Block defaultState() {
        return Block.fromBlockId(this.id());
    }

    @Override
    public String getProperty(@NotNull String property) {
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        int length = propertyTypes.length;
        if (length == 0) {
            return null;
        }
        byte key = BlockImpl.findKeyIndex(propertyTypes, property);
        if (key == -1) {
            return null;
        }
        long index = BlockImpl.extractIndex(this.propertiesArray, key);
        return propertyTypes[key].values().get((int)index);
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Block> possibleStates() {
        return (Collection)Collection.class.cast(this.possibleProperties().values());
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return tag.read(Objects.requireNonNullElse(this.nbt, CompoundBinaryTag.empty()));
    }

    private Long2ObjectArrayMap<BlockImpl> possibleProperties() {
        return POSSIBLE_STATES.get(this.id());
    }

    @Override
    public String toString() {
        return String.format("%s{properties=%s, nbt=%s, handler=%s}", this.name(), this.properties(), this.nbt, this.handler);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockImpl)) {
            return false;
        }
        BlockImpl block = (BlockImpl)o;
        return this.stateId() == block.stateId() && Objects.equals(this.nbt, block.nbt) && Objects.equals(this.handler, block.handler);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stateId(), this.nbt, this.handler);
    }

    private Block compute(long updatedProperties) {
        if (updatedProperties == this.propertiesArray) {
            return this;
        }
        BlockImpl block = (BlockImpl)this.possibleProperties().get(updatedProperties);
        assert (block != null);
        if (this.nbt == null && this.handler == null) {
            return block;
        }
        return new BlockImpl(block.registry(), block.propertiesArray, this.nbt, this.handler);
    }

    private static byte findKeyIndex(PropertyType[] properties, String key) {
        for (byte i = 0; i < properties.length; i = (byte)(i + 1)) {
            if (!properties[i].key().equals(key)) continue;
            return i;
        }
        return -1;
    }

    private static byte findValueIndex(PropertyType propertyType, String value) {
        List<String> values = propertyType.values();
        return (byte)values.indexOf(value);
    }

    private static byte findKeyIndexThrow(PropertyType[] properties, String key, BlockImpl block) {
        byte index = BlockImpl.findKeyIndex(properties, key);
        if (index == -1) {
            if (block != null) {
                throw new IllegalArgumentException("Property " + key + " is not valid for block " + String.valueOf(block));
            }
            throw new IllegalArgumentException("Unknown property key: " + key);
        }
        return index;
    }

    private static byte findValueIndexThrow(PropertyType propertyType, String value, BlockImpl block) {
        byte index = BlockImpl.findValueIndex(propertyType, value);
        if (index == -1) {
            if (block != null) {
                throw new IllegalArgumentException("Property " + propertyType.key() + " value " + value + " is not valid for block " + String.valueOf(block));
            }
            throw new IllegalArgumentException("Unknown property value: " + value);
        }
        return index;
    }

    static long updateIndex(long value, int index, byte newValue) {
        int position = index * 5;
        int mask = 31;
        value &= 31L << position ^ 0xFFFFFFFFFFFFFFFFL;
        return value |= (long)(newValue & 0x1F) << position;
    }

    static long extractIndex(long value, int index) {
        int position = index * 5;
        int mask = 31;
        return value >> position & 0x1FL;
    }

    @Override
    @NotNull
    public RegistryData.BlockEntry registry() {
        return this.registry;
    }

    public long propertiesArray() {
        return this.propertiesArray;
    }

    @Override
    @Nullable
    public CompoundBinaryTag nbt() {
        return this.nbt;
    }

    @Override
    @Nullable
    public BlockHandler handler() {
        return this.handler;
    }

    static {
        ObjectArray blockStateMap = ObjectArray.singleThread();
        ObjectArray propertiesType = ObjectArray.singleThread();
        ObjectArray possibleStates = ObjectArray.singleThread();
        HashMap internCache = new HashMap();
        REGISTRY = RegistryData.createStaticRegistry(Key.key((String)"minecraft:block"), (namespace, properties) -> {
            PropertyType[] propertyTypes;
            int blockId = properties.getInt("id");
            RegistryData.Properties stateObject = properties.section("states");
            RegistryData.Properties stateProperties = properties.section("properties");
            if (stateProperties != null) {
                int stateCount = stateProperties.size();
                if (stateCount > 12) {
                    throw new IllegalStateException("Too many properties for block " + namespace);
                }
                propertyTypes = new PropertyType[stateCount];
                int i = 0;
                for (Map.Entry<String, Object> entry : stateProperties) {
                    String k = entry.getKey();
                    List v = (List)entry.getValue();
                    assert (v.size() < 32);
                    propertyTypes[i++] = new PropertyType(k, v);
                }
            } else {
                propertyTypes = new PropertyType[]{};
            }
            propertiesType.set(blockId, propertyTypes);
            RegistryData.BlockEntry baseBlockEntry = RegistryData.block(namespace, properties, internCache, null, null);
            int propertiesCount = stateObject.size();
            long[] propertiesKeys = new long[propertiesCount];
            Object[] blocksValues = new BlockImpl[propertiesCount];
            int propertiesOffset = 0;
            for (Map.Entry<String, Object> stateEntry : stateObject) {
                String query = stateEntry.getKey();
                Map stateOverride = (Map)stateEntry.getValue();
                Map<String, String> propertyMap = BlockUtils.parseProperties(query);
                assert (propertyTypes.length == propertyMap.size());
                long propertiesValue = 0L;
                for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                    byte keyIndex = BlockImpl.findKeyIndexThrow(propertyTypes, entry.getKey(), null);
                    byte valueIndex = BlockImpl.findValueIndexThrow(propertyTypes[keyIndex], entry.getValue(), null);
                    propertiesValue = BlockImpl.updateIndex(propertiesValue, keyIndex, valueIndex);
                }
                RegistryData.BlockEntry entryOverride = RegistryData.block(namespace, RegistryData.Properties.fromMap(stateOverride), internCache, baseBlockEntry, properties);
                BlockImpl block = new BlockImpl(entryOverride, propertiesValue, null, null);
                blockStateMap.set(block.stateId(), block);
                propertiesKeys[propertiesOffset] = propertiesValue;
                blocksValues[propertiesOffset++] = block;
            }
            possibleStates.set(blockId, new Long2ObjectArrayMap(propertiesKeys, blocksValues, propertiesOffset));
            int defaultState = properties.getInt("defaultStateId");
            return (Block)blockStateMap.get(defaultState);
        });
        BLOCK_STATE_MAP = blockStateMap.toList();
        PROPERTIES_TYPE = propertiesType.toList();
        POSSIBLE_STATES = possibleStates.toList();
    }

    private record PropertyType(String key, List<String> values) {
    }
}

