/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.query.response;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extras.query.response.FullQueryResponse;
import org.jetbrains.annotations.NotNull;

public enum QueryKey {
    HOSTNAME(() -> "A Minestom Server"),
    GAME_TYPE(() -> "SMP"),
    GAME_ID("game_id", () -> "MINECRAFT"),
    VERSION(() -> "1.21.5"),
    PLUGINS(FullQueryResponse::generatePluginsValue),
    MAP(() -> "world"),
    NUM_PLAYERS("numplayers", () -> String.valueOf(MinecraftServer.getConnectionManager().getOnlinePlayerCount())),
    MAX_PLAYERS("maxplayers", () -> String.valueOf(MinecraftServer.getConnectionManager().getOnlinePlayerCount() + 1)),
    HOST_PORT("hostport", () -> String.valueOf(MinecraftServer.getServer().getPort())),
    HOST_IP("hostip", () -> Objects.requireNonNullElse(MinecraftServer.getServer().getAddress(), "localhost"));

    static QueryKey[] VALUES;
    private final String key;
    private final Supplier<String> value;

    private QueryKey(Supplier<String> value) {
        this(null, value);
    }

    private QueryKey(String key, Supplier<String> value) {
        this.key = Objects.requireNonNullElse(key, this.name().toLowerCase(Locale.ROOT).replace('_', ' '));
        this.value = value;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getValue() {
        return this.value.get();
    }

    static {
        VALUES = QueryKey.values();
    }
}

