/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.color;

import java.util.Objects;
import net.kyori.adventure.util.ARGBLike;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.codec.Codec;
import net.minestom.server.color.Color;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public final class AlphaColor
extends Color
implements ARGBLike {
    private static final int BIT_MASK = 255;
    public static final NetworkBuffer.Type<AlphaColor> NETWORK_TYPE = NetworkBuffer.INT.transform(AlphaColor::new, AlphaColor::asARGB);
    public static final Codec<AlphaColor> CODEC = Codec.INT.transform(AlphaColor::new, AlphaColor::asARGB);
    public static final AlphaColor WHITE = new AlphaColor(255, 255, 255, 255);
    private final int alpha;

    public AlphaColor(int alpha, int red, int green, int blue) {
        super(red, green, blue);
        Check.argCondition(!MathUtils.isBetween(alpha, 0, 255), "Alpha is not between 0-255: {0}", alpha);
        this.alpha = alpha;
    }

    public AlphaColor(int argb) {
        this(argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
    }

    public AlphaColor(int alpha, @NotNull RGBLike rgbLike) {
        this(alpha, rgbLike.red(), rgbLike.green(), rgbLike.blue());
    }

    @Override
    @NotNull
    public AlphaColor withRed(int red) {
        return new AlphaColor(this.alpha(), red, this.green(), this.blue());
    }

    @Override
    @NotNull
    public AlphaColor withGreen(int green) {
        return new AlphaColor(this.alpha(), this.red(), green, this.blue());
    }

    @Override
    @NotNull
    public AlphaColor withBlue(int blue) {
        return new AlphaColor(this.alpha(), this.red(), this.green(), blue);
    }

    @Override
    @NotNull
    public AlphaColor withAlpha(int alpha) {
        return new AlphaColor(alpha, this.red(), this.green(), this.blue());
    }

    public int asARGB() {
        return (this.alpha << 24) + this.asRGB();
    }

    public int alpha() {
        return this.alpha;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AlphaColor that = (AlphaColor)obj;
        return this.alpha == that.alpha && this.red() == that.red() && this.green() == that.green() && this.blue() == that.blue();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alpha, this.red(), this.green(), this.blue());
    }

    @Override
    public String toString() {
        return "AlphaColor[alpha=" + this.alpha + ", red=" + this.red() + ", green=" + this.green() + ", blue=" + this.blue() + "]";
    }
}

