/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.entity;

import java.util.Set;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;

public final class EntityUtils {
    private static final Set<EntityType> SITTING_ENTITIES = Set.of(EntityType.ZOMBIE, EntityType.HUSK, EntityType.DROWNED, EntityType.SKELETON, EntityType.STRAY, EntityType.WITHER_SKELETON, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.ZOMBIFIED_PIGLIN);

    public static double getPassengerHeightOffset(@NotNull Entity vehicle, @NotNull Entity passenger) {
        if (vehicle.getEntityType() == EntityType.BOAT) {
            return -0.1;
        }
        if (vehicle.getEntityType() == EntityType.MINECART) {
            return 0.0;
        }
        if (SITTING_ENTITIES.contains(passenger.getEntityType())) {
            return vehicle.getBoundingBox().height() * 0.75;
        }
        return vehicle.getBoundingBox().height();
    }

    private EntityUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOnGround(@NotNull Entity entity) {
        Chunk chunk = entity.getChunk();
        if (chunk == null) {
            return false;
        }
        Pos entityPosition = entity.getPosition();
        try {
            Block block;
            Chunk chunk2 = chunk;
            synchronized (chunk2) {
                block = chunk.getBlock(entityPosition.sub(0.0, 1.0, 0.0));
            }
            return block.isSolid();
        }
        catch (NullPointerException e) {
            return false;
        }
    }
}

