/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.network.PacketProcessor;
import net.minestom.server.network.socket.Worker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    public static final boolean NO_DELAY = true;
    private volatile boolean stop;
    private final Selector selector = Selector.open();
    private final PacketProcessor packetProcessor;
    private final List<Worker> workers;
    private int index;
    private ServerSocketChannel serverSocket;
    private SocketAddress socketAddress;
    private String address;
    private int port;

    public Server(PacketProcessor packetProcessor) throws IOException {
        this.packetProcessor = packetProcessor;
        Worker[] workers = new Worker[ServerFlag.WORKER_COUNT];
        Arrays.setAll(workers, value -> new Worker(this));
        this.workers = List.of(workers);
    }

    @ApiStatus.Internal
    public void init(SocketAddress address) throws IOException {
        StandardProtocolFamily family;
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            this.address = inetSocketAddress.getHostString();
            this.port = inetSocketAddress.getPort();
            family = inetSocketAddress.getAddress().getAddress().length == 4 ? StandardProtocolFamily.INET : StandardProtocolFamily.INET6;
        } else if (address instanceof UnixDomainSocketAddress) {
            UnixDomainSocketAddress unixDomainSocketAddress = (UnixDomainSocketAddress)address;
            this.address = "unix://" + String.valueOf(unixDomainSocketAddress.getPath());
            this.port = 0;
            family = StandardProtocolFamily.UNIX;
        } else {
            throw new IllegalArgumentException("Address must be an InetSocketAddress or a UnixDomainSocketAddress");
        }
        ServerSocketChannel server = ServerSocketChannel.open(family);
        server.bind(address);
        server.configureBlocking(false);
        server.register(this.selector, 16);
        this.serverSocket = server;
        this.socketAddress = address;
        if (address instanceof InetSocketAddress && this.port == 0) {
            this.port = server.socket().getLocalPort();
        }
    }

    @ApiStatus.Internal
    public void start() {
        this.workers.forEach(Thread::start);
        new Thread(() -> {
            while (!this.stop) {
                try {
                    this.selector.select(key -> {
                        if (!key.isAcceptable()) {
                            return;
                        }
                        try {
                            Worker worker = this.findWorker();
                            SocketChannel client = this.serverSocket.accept();
                            worker.receiveConnection(client);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (IOException e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            }
        }, "Ms-entrypoint").start();
    }

    public void tick() {
        this.workers.forEach(Worker::tick);
    }

    public boolean isOpen() {
        return !this.stop;
    }

    public void stop() {
        this.stop = true;
        try {
            SocketAddress socketAddress;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            if ((socketAddress = this.socketAddress) instanceof UnixDomainSocketAddress) {
                UnixDomainSocketAddress unixDomainSocketAddress = (UnixDomainSocketAddress)socketAddress;
                Files.deleteIfExists(unixDomainSocketAddress.getPath());
            }
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
        try {
            this.selector.wakeup();
            this.selector.close();
        }
        catch (IOException e) {
            LOGGER.error("Server socket sector could not be closed", (Throwable)e);
            System.exit(-1);
        }
        this.workers.forEach(Worker::close);
    }

    @ApiStatus.Internal
    @NotNull
    public PacketProcessor packetProcessor() {
        return this.packetProcessor;
    }

    public SocketAddress socketAddress() {
        return this.socketAddress;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    private Worker findWorker() {
        ++this.index;
        this.index %= ServerFlag.WORKER_COUNT;
        return this.workers.get(this.index);
    }
}

