/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryCloseEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.common.ClientPongPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.server.common.PingPacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;

public class WindowListener {
    public static void clickWindowListener(ClientClickWindowPacket packet, Player player) {
        AbstractInventory inventory;
        byte windowId = packet.windowId();
        AbstractInventory abstractInventory = inventory = windowId == 0 ? player.getInventory() : player.getOpenInventory();
        if (inventory == null) {
            return;
        }
        short slot = packet.slot();
        byte button = packet.button();
        ClientClickWindowPacket.ClickType clickType = packet.clickType();
        boolean successful = false;
        if (slot == -1) {
            return;
        }
        if (clickType == ClientClickWindowPacket.ClickType.PICKUP) {
            if (button == 0) {
                successful = slot != -999 ? inventory.leftClick(player, slot) : inventory.drop(player, true, slot, button);
            } else if (button == 1) {
                successful = slot != -999 ? inventory.rightClick(player, slot) : inventory.drop(player, false, slot, button);
            }
        } else if (clickType == ClientClickWindowPacket.ClickType.QUICK_MOVE) {
            successful = inventory.shiftClick(player, slot);
        } else if (clickType == ClientClickWindowPacket.ClickType.SWAP) {
            successful = inventory.changeHeld(player, slot, button);
        } else if (clickType == ClientClickWindowPacket.ClickType.CLONE) {
            successful = player.isCreative();
            if (successful) {
                WindowListener.setCursor(player, inventory, packet.clickedItem());
            }
        } else if (clickType == ClientClickWindowPacket.ClickType.THROW) {
            successful = inventory.drop(player, false, slot, button);
        } else if (clickType == ClientClickWindowPacket.ClickType.QUICK_CRAFT) {
            successful = inventory.dragging(player, slot, button);
        } else if (clickType == ClientClickWindowPacket.ClickType.PICKUP_ALL) {
            successful = inventory.doubleClick(player, slot);
        }
        if (!successful) {
            player.getInventory().update();
            if (inventory instanceof Inventory) {
                ((Inventory)inventory).update(player);
            }
        }
        WindowListener.refreshCursorItem(player, inventory);
        player.sendPacket(new PingPacket(0x40000000 | windowId << 16));
    }

    public static void pong(ClientPongPacket packet, Player player) {
    }

    public static void closeWindowListener(ClientCloseWindowPacket packet, Player player) {
        InventoryCloseEvent inventoryCloseEvent = new InventoryCloseEvent(player.getOpenInventory(), player);
        EventDispatcher.call(inventoryCloseEvent);
        player.closeInventory(true);
        Inventory newInventory = inventoryCloseEvent.getNewInventory();
        if (newInventory != null) {
            player.openInventory(newInventory);
        }
    }

    private static void refreshCursorItem(Player player, AbstractInventory inventory) {
        ItemStack cursorItem;
        if (inventory instanceof PlayerInventory) {
            PlayerInventory playerInventory = (PlayerInventory)inventory;
            cursorItem = playerInventory.getCursorItem();
        } else if (inventory instanceof Inventory) {
            Inventory standardInventory = (Inventory)inventory;
            cursorItem = standardInventory.getCursorItem(player);
        } else {
            throw new RuntimeException("Invalid inventory: " + String.valueOf(inventory.getClass()));
        }
        SetSlotPacket setSlotPacket = SetSlotPacket.createCursorPacket(cursorItem);
        player.sendPacket(setSlotPacket);
    }

    private static void setCursor(Player player, AbstractInventory inventory, ItemStack itemStack) {
        if (inventory instanceof PlayerInventory) {
            PlayerInventory playerInventory = (PlayerInventory)inventory;
            playerInventory.setCursorItem(itemStack);
        } else if (inventory instanceof Inventory) {
            Inventory standardInventory = (Inventory)inventory;
            standardInventory.setCursorItem(player, itemStack);
        } else {
            throw new RuntimeException("Invalid inventory: " + String.valueOf(inventory.getClass()));
        }
    }
}

