/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biome;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.coordinate.Point;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.world.biome.BiomeEffects;
import net.minestom.server.world.biome.BiomeImpl;
import net.minestom.server.world.biome.Biomes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public sealed interface Biome
extends Biomes
permits BiomeImpl {
    @NotNull
    public static final Codec<Biome> REGISTRY_CODEC = StructCodec.struct("temperature", Codec.FLOAT, Biome::temperature, "downfall", Codec.FLOAT, Biome::downfall, "has_precipitation", Codec.BOOLEAN, Biome::hasPrecipitation, "temperature_modifier", TemperatureModifier.CODEC.optional(TemperatureModifier.NONE), Biome::temperatureModifier, "effects", BiomeEffects.CODEC.optional(BiomeEffects.PLAINS_EFFECTS), Biome::effects, Biome::create);
    @NotNull
    public static final Codec<Biome> NETWORK_CODEC = StructCodec.struct("temperature", Codec.FLOAT, Biome::temperature, "downfall", Codec.FLOAT, Biome::downfall, "has_precipitation", Codec.BOOLEAN, Biome::hasPrecipitation, "temperature_modifier", TemperatureModifier.CODEC, Biome::temperatureModifier, "effects", BiomeEffects.CODEC, Biome::effects, Biome::create);

    @NotNull
    public static Biome create(float temperature, float downfall, boolean hasPrecipitation, @NotNull TemperatureModifier temperatureModifier, @NotNull BiomeEffects effects) {
        return new BiomeImpl(temperature, downfall, effects, hasPrecipitation, temperatureModifier);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Biome> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key((String)"minecraft:worldgen/biome"), NETWORK_CODEC, null, RegistryData.Resource.BIOMES, (a, b) -> a.equals("minecraft:plains") ? -1 : (b.equals("minecraft:plains") ? 1 : 0), REGISTRY_CODEC);
    }

    public float temperature();

    public float downfall();

    @NotNull
    public BiomeEffects effects();

    public boolean hasPrecipitation();

    @NotNull
    public TemperatureModifier temperatureModifier();

    public static enum TemperatureModifier {
        NONE,
        FROZEN;

        public static final Codec<TemperatureModifier> CODEC;

        static {
            CODEC = Codec.Enum(TemperatureModifier.class);
        }
    }

    public static final class Builder {
        private float temperature = 0.25f;
        private float downfall = 0.8f;
        private BiomeEffects effects = BiomeEffects.PLAINS_EFFECTS;
        private boolean hasPrecipitation = false;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder downfall(float downfall) {
            this.downfall = downfall;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder effects(@NotNull BiomeEffects effects) {
            this.effects = effects;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder hasPrecipitation(boolean precipitation) {
            this.hasPrecipitation = precipitation;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder temperatureModifier(@NotNull TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Biome build() {
            return new BiomeImpl(this.temperature, this.downfall, this.effects, this.hasPrecipitation, this.temperatureModifier);
        }
    }

    public static interface Getter {
        @NotNull
        public RegistryKey<Biome> getBiome(int var1, int var2, int var3);

        @NotNull
        default public RegistryKey<Biome> getBiome(@NotNull Point point) {
            return this.getBiome(point.blockX(), point.blockY(), point.blockZ());
        }
    }

    public static interface Setter {
        public void setBiome(int var1, int var2, int var3, @NotNull RegistryKey<Biome> var4);

        default public void setBiome(@NotNull Point blockPosition, @NotNull RegistryKey<Biome> biome) {
            this.setBiome(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), biome);
        }
    }
}

