/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.collection;

import java.util.Arrays;
import java.util.List;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class ObjectArrayImpl {
    ObjectArrayImpl() {
    }

    static final class Concurrent<T>
    implements ObjectArray<T> {
        private volatile T[] array;
        private volatile int max = -1;

        Concurrent(int size) {
            this.array = new Object[size];
        }

        @Override
        public @UnknownNullability T get(int index) {
            T[] array = this.array;
            return index < array.length ? (T)array[index] : null;
        }

        @Override
        public synchronized void set(int index, @Nullable T object) {
            if (object == null) {
                this.remove(index);
                return;
            }
            T[] array = this.array;
            if (index >= array.length) {
                int newLength = index * 2 + 1;
                this.array = array = Arrays.copyOf(array, newLength);
            }
            array[index] = object;
            this.max = Math.max(this.max, index);
        }

        @Override
        public synchronized void remove(int index) {
            T[] array = this.array;
            if (index >= array.length) {
                return;
            }
            array[index] = null;
            int max = this.max;
            if (max == index) {
                int lastNotNull;
                for (lastNotNull = max - 1; lastNotNull >= 0 && array[lastNotNull] == null; --lastNotNull) {
                }
                this.max = lastNotNull;
            }
        }

        @Override
        public synchronized void trim() {
            this.array = Arrays.copyOf(this.array, this.max + 1);
        }

        @Override
        public @UnknownNullability T @NotNull [] arrayCopy(@NotNull Class<T> type) {
            return Arrays.copyOf(this.array, this.max + 1, (Class<? extends T[]>)type.arrayType());
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull T> toList() {
            T[] array = Arrays.copyOf(this.array, this.max + 1);
            return List.of(array);
        }
    }

    static final class SingleThread<T>
    implements ObjectArray<T> {
        private T[] array;
        private int max = -1;

        SingleThread(int size) {
            this.array = new Object[size];
        }

        @Override
        public @UnknownNullability T get(int index) {
            T[] array = this.array;
            return index < array.length ? (T)array[index] : null;
        }

        @Override
        public void set(int index, @Nullable T object) {
            if (object == null) {
                this.remove(index);
                return;
            }
            T[] array = this.array;
            if (index >= array.length) {
                int newLength = index * 2 + 1;
                this.array = array = Arrays.copyOf(array, newLength);
            }
            array[index] = object;
            this.max = Math.max(this.max, index);
        }

        @Override
        public void remove(int index) {
            T[] array = this.array;
            if (index >= array.length) {
                return;
            }
            array[index] = null;
            int max = this.max;
            if (max == index) {
                int lastNotNull;
                for (lastNotNull = max - 1; lastNotNull >= 0 && array[lastNotNull] == null; --lastNotNull) {
                }
                this.max = lastNotNull;
            }
        }

        @Override
        public void trim() {
            this.array = Arrays.copyOf(this.array, this.max + 1);
        }

        @Override
        public @UnknownNullability T @NotNull [] arrayCopy(@NotNull Class<T> type) {
            return Arrays.copyOf(this.array, this.max + 1, (Class<? extends T[]>)type.arrayType());
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull T> toList() {
            T[] array = Arrays.copyOf(this.array, this.max + 1);
            return List.of(array);
        }
    }
}

