/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.animal.ChickenVariant;
import net.minestom.server.entity.metadata.animal.CowVariant;
import net.minestom.server.entity.metadata.animal.FrogVariant;
import net.minestom.server.entity.metadata.animal.PigVariant;
import net.minestom.server.entity.metadata.animal.tameable.CatVariant;
import net.minestom.server.entity.metadata.animal.tameable.WolfSoundVariant;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariant;
import net.minestom.server.entity.metadata.other.PaintingVariant;
import net.minestom.server.game.GameEvent;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.instance.fluid.Fluid;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.item.armor.TrimPattern;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.message.ChatType;
import net.minestom.server.potion.PotionEffect;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registry;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.NotNull;

public interface Registries {
    @NotNull
    default public Registry<Block> blocks() {
        return Block.staticRegistry();
    }

    @NotNull
    default public Registry<Material> material() {
        return Material.staticRegistry();
    }

    @NotNull
    default public Registry<PotionEffect> potionEffect() {
        return PotionEffect.staticRegistry();
    }

    @NotNull
    default public Registry<EntityType> entityType() {
        return EntityType.staticRegistry();
    }

    @NotNull
    default public Registry<Fluid> fluid() {
        return Fluid.staticRegistry();
    }

    @NotNull
    default public Registry<GameEvent> gameEvent() {
        return GameEvent.staticRegistry();
    }

    @NotNull
    public DynamicRegistry<ChatType> chatType();

    @NotNull
    public DynamicRegistry<DimensionType> dimensionType();

    @NotNull
    public DynamicRegistry<Biome> biome();

    @NotNull
    public DynamicRegistry<DamageType> damageType();

    @NotNull
    public DynamicRegistry<TrimMaterial> trimMaterial();

    @NotNull
    public DynamicRegistry<TrimPattern> trimPattern();

    @NotNull
    public DynamicRegistry<BannerPattern> bannerPattern();

    @NotNull
    public DynamicRegistry<Enchantment> enchantment();

    @NotNull
    public DynamicRegistry<PaintingVariant> paintingVariant();

    @NotNull
    public DynamicRegistry<JukeboxSong> jukeboxSong();

    @NotNull
    public DynamicRegistry<Instrument> instrument();

    @NotNull
    public DynamicRegistry<WolfVariant> wolfVariant();

    @NotNull
    public DynamicRegistry<WolfSoundVariant> wolfSoundVariant();

    @NotNull
    public DynamicRegistry<CatVariant> catVariant();

    @NotNull
    public DynamicRegistry<ChickenVariant> chickenVariant();

    @NotNull
    public DynamicRegistry<CowVariant> cowVariant();

    @NotNull
    public DynamicRegistry<FrogVariant> frogVariant();

    @NotNull
    public DynamicRegistry<PigVariant> pigVariant();

    @NotNull
    public DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues();

    @NotNull
    public DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects();

    @NotNull
    public DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects();

    @NotNull
    public DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects();

    public static class Delegating
    implements Registries {
        private final Registries delegate;

        public Delegating(@NotNull Registries delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public Registry<Block> blocks() {
            return this.delegate.blocks();
        }

        @Override
        @NotNull
        public Registry<Material> material() {
            return this.delegate.material();
        }

        @Override
        @NotNull
        public Registry<PotionEffect> potionEffect() {
            return this.delegate.potionEffect();
        }

        @Override
        @NotNull
        public Registry<EntityType> entityType() {
            return this.delegate.entityType();
        }

        @Override
        @NotNull
        public Registry<Fluid> fluid() {
            return this.delegate.fluid();
        }

        @Override
        @NotNull
        public Registry<GameEvent> gameEvent() {
            return this.delegate.gameEvent();
        }

        @Override
        @NotNull
        public DynamicRegistry<ChatType> chatType() {
            return this.delegate.chatType();
        }

        @Override
        @NotNull
        public DynamicRegistry<DimensionType> dimensionType() {
            return this.delegate.dimensionType();
        }

        @Override
        @NotNull
        public DynamicRegistry<Biome> biome() {
            return this.delegate.biome();
        }

        @Override
        @NotNull
        public DynamicRegistry<DamageType> damageType() {
            return this.delegate.damageType();
        }

        @Override
        @NotNull
        public DynamicRegistry<TrimMaterial> trimMaterial() {
            return this.delegate.trimMaterial();
        }

        @Override
        @NotNull
        public DynamicRegistry<TrimPattern> trimPattern() {
            return this.delegate.trimPattern();
        }

        @Override
        @NotNull
        public DynamicRegistry<BannerPattern> bannerPattern() {
            return this.delegate.bannerPattern();
        }

        @Override
        @NotNull
        public DynamicRegistry<Enchantment> enchantment() {
            return this.delegate.enchantment();
        }

        @Override
        @NotNull
        public DynamicRegistry<PaintingVariant> paintingVariant() {
            return this.delegate.paintingVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<JukeboxSong> jukeboxSong() {
            return this.delegate.jukeboxSong();
        }

        @Override
        @NotNull
        public DynamicRegistry<Instrument> instrument() {
            return this.delegate.instrument();
        }

        @Override
        @NotNull
        public DynamicRegistry<WolfVariant> wolfVariant() {
            return this.delegate.wolfVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<WolfSoundVariant> wolfSoundVariant() {
            return this.delegate.wolfSoundVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<CatVariant> catVariant() {
            return this.delegate.catVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<ChickenVariant> chickenVariant() {
            return this.delegate.chickenVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<CowVariant> cowVariant() {
            return this.delegate.cowVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<FrogVariant> frogVariant() {
            return this.delegate.frogVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<PigVariant> pigVariant() {
            return this.delegate.pigVariant();
        }

        @Override
        @NotNull
        public DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues() {
            return this.delegate.enchantmentLevelBasedValues();
        }

        @Override
        @NotNull
        public DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects() {
            return this.delegate.enchantmentValueEffects();
        }

        @Override
        @NotNull
        public DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects() {
            return this.delegate.enchantmentEntityEffects();
        }

        @Override
        @NotNull
        public DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects() {
            return this.delegate.enchantmentLocationEffects();
        }
    }

    @FunctionalInterface
    public static interface Selector<T> {
        @NotNull
        public Registry<T> select(@NotNull Registries var1);
    }
}

