/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum RecipeBookCategory implements StaticProtocolObject<RecipeBookCategory>
{
    CRAFTING_BUILDING_BLOCKS("crafting_building_blocks"),
    CRAFTING_REDSTONE("crafting_redstone"),
    CRAFTING_EQUIPMENT("crafting_equipment"),
    CRAFTING_MISC("crafting_misc"),
    FURNACE_FOOD("furnace_food"),
    FURNACE_BLOCKS("furnace_blocks"),
    FURNACE_MISC("furnace_misc"),
    BLAST_FURNACE_BLOCKS("blast_furnace_blocks"),
    BLAST_FURNACE_MISC("blast_furnace_misc"),
    SMOKER_FOOD("smoker_food"),
    STONECUTTER("stonecutter"),
    SMITHING("smithing"),
    CAMPFIRE("campfire");

    private static final Map<Key, RecipeBookCategory> BY_KEY;
    public static final NetworkBuffer.Type<RecipeBookCategory> NETWORK_TYPE;
    public static final Codec<RecipeBookCategory> CODEC;
    private final Key key;

    private RecipeBookCategory(String key) {
        this.key = Key.key((String)key);
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(RecipeBookCategory.values()).collect(Collectors.toUnmodifiableMap(RecipeBookCategory::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(RecipeBookCategory.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, RecipeBookCategory::key);
    }
}

