/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record TeamsPacket(String teamName, Action action) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final int MAX_MEMBERS = 16384;
    public static final NetworkBuffer.Type<TeamsPacket> SERIALIZER = new NetworkBuffer.Type<TeamsPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, TeamsPacket value) {
            buffer.write(NetworkBuffer.STRING, value.teamName);
            buffer.write(NetworkBuffer.BYTE, (byte)value.action.id());
            NetworkBuffer.Type<? extends Action> type = TeamsPacket.actionSerializer(value.action.id());
            buffer.write(type, value.action);
        }

        @Override
        @NotNull
        public TeamsPacket read(@NotNull NetworkBuffer buffer) {
            String teamName = buffer.read(NetworkBuffer.STRING);
            byte actionId = buffer.read(NetworkBuffer.BYTE);
            NetworkBuffer.Type<? extends Action> type = TeamsPacket.actionSerializer(actionId);
            return new TeamsPacket(teamName, type.read(buffer));
        }
    };

    @Override
    @NotNull
    public Collection<Component> components() {
        Collection<Component> collection;
        Action action = this.action;
        if (action instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action);
            collection = holder.components();
        } else {
            collection = List.of();
        }
        return collection;
    }

    private static NetworkBuffer.Type<? extends Action> actionSerializer(int id) {
        return switch (id) {
            case 0 -> CreateTeamAction.SERIALIZER;
            case 1 -> RemoveTeamAction.SERIALIZER;
            case 2 -> UpdateTeamAction.SERIALIZER;
            case 3 -> AddEntitiesToTeamAction.SERIALIZER;
            case 4 -> RemoveEntitiesToTeamAction.SERIALIZER;
            default -> throw new RuntimeException("Unknown action id");
        };
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        Action action;
        Action action2 = this.action;
        if (action2 instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action2);
            action = (Action)holder.copyWithOperator(operator);
        } else {
            action = this.action;
        }
        return new TeamsPacket(this.teamName, action);
    }

    public static sealed interface Action
    permits CreateTeamAction, RemoveTeamAction, UpdateTeamAction, AddEntitiesToTeamAction, RemoveEntitiesToTeamAction {
        public int id();
    }

    public record CreateTeamAction(Component displayName, byte friendlyFlags, NameTagVisibility nameTagVisibility, CollisionRule collisionRule, NamedTextColor teamColor, Component teamPrefix, Component teamSuffix, List<String> entities) implements Action,
    ComponentHolder<CreateTeamAction>
    {
        public static final NetworkBuffer.Type<CreateTeamAction> SERIALIZER = new NetworkBuffer.Type<CreateTeamAction>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, CreateTeamAction value) {
                buffer.write(NetworkBuffer.COMPONENT, value.displayName);
                buffer.write(NetworkBuffer.BYTE, value.friendlyFlags);
                buffer.write(NameTagVisibility.NETWORK_TYPE, value.nameTagVisibility);
                buffer.write(CollisionRule.NETWORK_TYPE, value.collisionRule);
                buffer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getNamedTextColorValue(value.teamColor));
                buffer.write(NetworkBuffer.COMPONENT, value.teamPrefix);
                buffer.write(NetworkBuffer.COMPONENT, value.teamSuffix);
                buffer.write(NetworkBuffer.STRING.list(), value.entities);
            }

            @Override
            public CreateTeamAction read(@NotNull NetworkBuffer buffer) {
                return new CreateTeamAction(buffer.read(NetworkBuffer.COMPONENT), buffer.read(NetworkBuffer.BYTE), buffer.read(NameTagVisibility.NETWORK_TYPE), buffer.read(CollisionRule.NETWORK_TYPE), NamedTextColor.namedColor((int)buffer.read(NetworkBuffer.VAR_INT)), buffer.read(NetworkBuffer.COMPONENT), buffer.read(NetworkBuffer.COMPONENT), buffer.read(NetworkBuffer.STRING.list(16384)));
            }
        };

        public CreateTeamAction {
            entities = List.copyOf(entities);
        }

        @Override
        public int id() {
            return 0;
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.displayName, this.teamPrefix, this.teamSuffix);
        }

        @Override
        @NotNull
        public CreateTeamAction copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new CreateTeamAction((Component)operator.apply(this.displayName), this.friendlyFlags, this.nameTagVisibility, this.collisionRule, this.teamColor, (Component)operator.apply(this.teamPrefix), (Component)operator.apply(this.teamSuffix), this.entities);
        }
    }

    public record RemoveTeamAction() implements Action
    {
        public static final NetworkBuffer.Type<RemoveTeamAction> SERIALIZER = NetworkBufferTemplate.template(RemoveTeamAction::new);

        @Override
        public int id() {
            return 1;
        }
    }

    public record UpdateTeamAction(Component displayName, byte friendlyFlags, NameTagVisibility nameTagVisibility, CollisionRule collisionRule, NamedTextColor teamColor, Component teamPrefix, Component teamSuffix) implements Action,
    ComponentHolder<UpdateTeamAction>
    {
        public static final NetworkBuffer.Type<UpdateTeamAction> SERIALIZER = new NetworkBuffer.Type<UpdateTeamAction>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, UpdateTeamAction value) {
                buffer.write(NetworkBuffer.COMPONENT, value.displayName);
                buffer.write(NetworkBuffer.BYTE, value.friendlyFlags);
                buffer.write(NameTagVisibility.NETWORK_TYPE, value.nameTagVisibility);
                buffer.write(CollisionRule.NETWORK_TYPE, value.collisionRule);
                buffer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getNamedTextColorValue(value.teamColor));
                buffer.write(NetworkBuffer.COMPONENT, value.teamPrefix);
                buffer.write(NetworkBuffer.COMPONENT, value.teamSuffix);
            }

            @Override
            public UpdateTeamAction read(@NotNull NetworkBuffer buffer) {
                return new UpdateTeamAction(buffer.read(NetworkBuffer.COMPONENT), buffer.read(NetworkBuffer.BYTE), buffer.read(NameTagVisibility.NETWORK_TYPE), buffer.read(CollisionRule.NETWORK_TYPE), NamedTextColor.namedColor((int)buffer.read(NetworkBuffer.VAR_INT)), buffer.read(NetworkBuffer.COMPONENT), buffer.read(NetworkBuffer.COMPONENT));
            }
        };

        @Override
        public int id() {
            return 2;
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.displayName, this.teamPrefix, this.teamSuffix);
        }

        @Override
        @NotNull
        public UpdateTeamAction copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new UpdateTeamAction((Component)operator.apply(this.displayName), this.friendlyFlags, this.nameTagVisibility, this.collisionRule, this.teamColor, (Component)operator.apply(this.teamPrefix), (Component)operator.apply(this.teamSuffix));
        }
    }

    public record AddEntitiesToTeamAction(@NotNull @NotNull List<@NotNull String> entities) implements Action
    {
        public static final NetworkBuffer.Type<AddEntitiesToTeamAction> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING.list(16384), AddEntitiesToTeamAction::entities, AddEntitiesToTeamAction::new);

        public AddEntitiesToTeamAction(@NotNull List<String> entities) {
            entities = List.copyOf(entities);
        }

        public AddEntitiesToTeamAction(Collection<String> entities) {
            this(List.copyOf(entities));
        }

        @Override
        public int id() {
            return 3;
        }
    }

    public record RemoveEntitiesToTeamAction(@NotNull @NotNull List<@NotNull String> entities) implements Action
    {
        public static final NetworkBuffer.Type<RemoveEntitiesToTeamAction> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING.list(16384), RemoveEntitiesToTeamAction::entities, RemoveEntitiesToTeamAction::new);

        public RemoveEntitiesToTeamAction(@NotNull List<String> entities) {
            entities = List.copyOf(entities);
        }

        public RemoveEntitiesToTeamAction(Collection<String> entities) {
            this(List.copyOf(entities));
        }

        @Override
        public int id() {
            return 4;
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        public static final NetworkBuffer.Type<CollisionRule> NETWORK_TYPE;
        private final String identifier;

        private CollisionRule(String identifier) {
            this.identifier = identifier;
        }

        @NotNull
        public static CollisionRule fromIdentifier(String identifier) {
            for (CollisionRule v : CollisionRule.values()) {
                if (!v.getIdentifier().equals(identifier)) continue;
                return v;
            }
            Check.fail("Identifier for CollisionRule is invalid: " + identifier);
            return null;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(CollisionRule.class);
        }
    }

    public static enum NameTagVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        public static final NetworkBuffer.Type<NameTagVisibility> NETWORK_TYPE;
        private final String identifier;

        private NameTagVisibility(String identifier) {
            this.identifier = identifier;
        }

        @NotNull
        public static NameTagVisibility fromIdentifier(String identifier) {
            for (NameTagVisibility v : NameTagVisibility.values()) {
                if (!v.getIdentifier().equals(identifier)) continue;
                return v;
            }
            Check.fail("Identifier for NameTagVisibility is invalid: " + identifier);
            return null;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(NameTagVisibility.class);
        }
    }
}

