/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockEntityDataPacket(@NotNull Point blockPosition, int action, @Nullable CompoundBinaryTag data) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<BlockEntityDataPacket> SERIALIZER = new NetworkBuffer.Type<BlockEntityDataPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, BlockEntityDataPacket value) {
            buffer.write(NetworkBuffer.BLOCK_POSITION, value.blockPosition);
            buffer.write(NetworkBuffer.VAR_INT, value.action);
            if (value.data != null) {
                buffer.write(NetworkBuffer.NBT_COMPOUND, value.data);
            } else {
                buffer.write(NetworkBuffer.BYTE, (byte)0);
            }
        }

        @Override
        public BlockEntityDataPacket read(@NotNull NetworkBuffer buffer) {
            return new BlockEntityDataPacket(buffer.read(NetworkBuffer.BLOCK_POSITION), buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.NBT_COMPOUND));
        }
    };
}

