/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.client.ClientPacket;

public record ClientInputPacket(byte flags) implements ClientPacket
{
    private static final byte FLAG_FORWARD = 1;
    private static final byte FLAG_BACKWARD = 2;
    private static final byte FLAG_LEFT = 4;
    private static final byte FLAG_RIGHT = 8;
    private static final byte FLAG_JUMP = 16;
    private static final byte FLAG_SHIFT = 32;
    private static final byte FLAG_SPRINT = 64;
    public static final NetworkBuffer.Type<ClientInputPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.BYTE, ClientInputPacket::flags, ClientInputPacket::new);

    public ClientInputPacket(boolean forward, boolean backward, boolean left, boolean right, boolean jump, boolean shift, boolean sprint) {
        this((byte)((forward ? 1 : 0) | (backward ? 2 : 0) | (left ? 4 : 0) | (right ? 8 : 0) | (jump ? 16 : 0) | (shift ? 32 : 0) | (sprint ? 64 : 0)));
    }

    public boolean forward() {
        return (this.flags & 1) != 0;
    }

    public boolean backward() {
        return (this.flags & 2) != 0;
    }

    public boolean left() {
        return (this.flags & 4) != 0;
    }

    public boolean right() {
        return (this.flags & 8) != 0;
    }

    public boolean jump() {
        return (this.flags & 0x10) != 0;
    }

    public boolean shift() {
        return (this.flags & 0x20) != 0;
    }

    public boolean sprint() {
        return (this.flags & 0x40) != 0;
    }
}

