/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.PacketRegistry;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public sealed interface PacketParser<T> {
    @NotNull
    public PacketRegistry<T> handshake();

    @NotNull
    public PacketRegistry<T> status();

    @NotNull
    public PacketRegistry<T> login();

    @NotNull
    public PacketRegistry<T> configuration();

    @NotNull
    public PacketRegistry<T> play();

    @NotNull
    default public T parse(@NotNull ConnectionState connectionState, int packetId, @NotNull NetworkBuffer buffer) {
        PacketRegistry<T> registry = this.stateRegistry(connectionState);
        return registry.create(packetId, buffer);
    }

    @NotNull
    default public PacketRegistry<T> stateRegistry(@NotNull ConnectionState connectionState) {
        return switch (connectionState) {
            default -> throw new MatchException(null, null);
            case ConnectionState.HANDSHAKE -> this.handshake();
            case ConnectionState.STATUS -> this.status();
            case ConnectionState.LOGIN -> this.login();
            case ConnectionState.CONFIGURATION -> this.configuration();
            case ConnectionState.PLAY -> this.play();
        };
    }

    public record Server(PacketRegistry<ServerPacket> handshake, PacketRegistry<ServerPacket> status, PacketRegistry<ServerPacket> login, PacketRegistry<ServerPacket> configuration, PacketRegistry<ServerPacket> play) implements PacketParser<ServerPacket>
    {
        public Server() {
            this(new PacketRegistry.ServerHandshake(), new PacketRegistry.ServerStatus(), new PacketRegistry.ServerLogin(), new PacketRegistry.ServerConfiguration(), new PacketRegistry.ServerPlay());
        }
    }

    public record Client(PacketRegistry<ClientPacket> handshake, PacketRegistry<ClientPacket> status, PacketRegistry<ClientPacket> login, PacketRegistry<ClientPacket> configuration, PacketRegistry<ClientPacket> play) implements PacketParser<ClientPacket>
    {
        public Client() {
            this(new PacketRegistry.ClientHandshake(), new PacketRegistry.ClientStatus(), new PacketRegistry.ClientLogin(), new PacketRegistry.ClientConfiguration(), new PacketRegistry.ClientPlay());
        }
    }
}

