/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.List;
import java.util.function.Predicate;
import net.minestom.server.codec.Codec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.predicate.BlockPredicate;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public record BlockPredicates(@NotNull List<BlockPredicate> predicates) implements Predicate<Block>
{
    public static final BlockPredicates NEVER = new BlockPredicates(List.of());
    public static final NetworkBuffer.Type<BlockPredicates> NETWORK_TYPE = BlockPredicate.NETWORK_TYPE.list(Short.MAX_VALUE).transform(BlockPredicates::new, BlockPredicates::predicates);
    public static final Codec<BlockPredicates> CODEC = BlockPredicate.CODEC.listOrSingle(Short.MAX_VALUE).transform(BlockPredicates::new, BlockPredicates::predicates);

    public BlockPredicates(@NotNull List<BlockPredicate> predicates) {
        predicates = List.copyOf(predicates);
    }

    public BlockPredicates(@NotNull BlockPredicate predicate) {
        this(List.of(predicate));
    }

    @Override
    public boolean test(Block block) {
        for (BlockPredicate predicate : this.predicates) {
            if (!predicate.test(block)) continue;
            return true;
        }
        return false;
    }
}

