/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.EquipmentSlotGroup;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;

public record AttributeList(@NotNull List<Modifier> modifiers) {
    public static final AttributeList EMPTY = new AttributeList(List.of());
    public static final NetworkBuffer.Type<AttributeList> NETWORK_TYPE = Modifier.NETWORK_TYPE.list(Short.MAX_VALUE).transform(AttributeList::new, AttributeList::modifiers);
    public static final Codec<AttributeList> CODEC = Modifier.CODEC.list(Short.MAX_VALUE).transform(AttributeList::new, AttributeList::modifiers);

    public AttributeList(@NotNull List<Modifier> modifiers) {
        modifiers = List.copyOf(modifiers);
    }

    public AttributeList(@NotNull Modifier modifier) {
        this(List.of(modifier));
    }

    @NotNull
    public AttributeList with(@NotNull Modifier modifier) {
        ArrayList<Modifier> newModifiers = new ArrayList<Modifier>(this.modifiers);
        newModifiers.add(modifier);
        return new AttributeList(newModifiers);
    }

    @NotNull
    public AttributeList remove(@NotNull Modifier modifier) {
        ArrayList<Modifier> newModifiers = new ArrayList<Modifier>(this.modifiers);
        newModifiers.remove(modifier);
        return new AttributeList(newModifiers);
    }

    public record Modifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier, @NotNull EquipmentSlotGroup slot) {
        public static final NetworkBuffer.Type<Modifier> NETWORK_TYPE = NetworkBufferTemplate.template(Attribute.NETWORK_TYPE, Modifier::attribute, AttributeModifier.NETWORK_TYPE, Modifier::modifier, NetworkBuffer.Enum(EquipmentSlotGroup.class), Modifier::slot, Modifier::new);
        public static final Codec<Modifier> CODEC = StructCodec.struct("type", Attribute.CODEC, Modifier::attribute, "$$inline$$", AttributeModifier.CODEC, Modifier::modifier, "slot", EquipmentSlotGroup.CODEC.optional(EquipmentSlotGroup.ANY), Modifier::slot, Modifier::new);
    }
}

