/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.click;

import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClickPreprocessor {
    private final Set<Integer> leftDrag = new LinkedHashSet<Integer>();
    private final Set<Integer> rightDrag = new LinkedHashSet<Integer>();
    private final Set<Integer> middleDrag = new LinkedHashSet<Integer>();

    public void clearCache() {
        this.leftDrag.clear();
        this.rightDrag.clear();
        this.middleDrag.clear();
    }

    public boolean isCreativeClick(@NotNull Click click, boolean hasCursorItem) {
        Click click2 = click;
        Objects.requireNonNull(click2);
        Click click3 = click2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Click.Middle.class, Click.MiddleDrag.class}, (Object)click3, n)) {
            case 0 -> {
                Click.Middle ignored = (Click.Middle)click3;
                if (!hasCursorItem) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Click.MiddleDrag ignored = (Click.MiddleDrag)click3;
                yield true;
            }
            default -> false;
        };
    }

    @Nullable
    public Click processClick(@NotNull ClientClickWindowPacket packet, @Nullable Integer containerSize) {
        boolean valid;
        int slot = containerSize == null ? PlayerInventoryUtils.convertWindow0SlotToMinestomSlot(packet.slot()) : (packet.slot() >= containerSize ? containerSize + PlayerInventoryUtils.convertWindowSlotToMinestomSlot(packet.slot(), containerSize) : (int)packet.slot());
        int maxSize = containerSize == null ? 46 : containerSize + 36;
        boolean bl = valid = slot >= 0 && slot < maxSize;
        if (valid) {
            return this.process(packet.clickType(), slot, packet.button());
        }
        return slot == -999 ? this.processInvalidSlot(packet.clickType(), packet.button()) : null;
    }

    @Nullable
    private Click processInvalidSlot(@NotNull ClientClickWindowPacket.ClickType type, byte button) {
        return switch (type) {
            case ClientClickWindowPacket.ClickType.PICKUP, ClientClickWindowPacket.ClickType.THROW -> {
                if (button == 0) {
                    yield new Click.LeftDropCursor();
                }
                if (button == 1) {
                    yield new Click.RightDropCursor();
                }
                yield null;
            }
            case ClientClickWindowPacket.ClickType.CLONE -> {
                if (button == 2) {
                    yield new Click.MiddleDropCursor();
                }
                yield null;
            }
            case ClientClickWindowPacket.ClickType.QUICK_CRAFT -> {
                if (button == 2) {
                    List<Integer> list = List.copyOf(this.leftDrag);
                    this.leftDrag.clear();
                    yield new Click.LeftDrag(list);
                }
                if (button == 6) {
                    List<Integer> list = List.copyOf(this.rightDrag);
                    this.rightDrag.clear();
                    yield new Click.RightDrag(list);
                }
                if (button == 10) {
                    List<Integer> list = List.copyOf(this.middleDrag);
                    this.middleDrag.clear();
                    yield new Click.MiddleDrag(list);
                }
                if (button == 0) {
                    this.leftDrag.clear();
                }
                if (button == 4) {
                    this.rightDrag.clear();
                }
                if (button == 8) {
                    this.middleDrag.clear();
                }
                yield null;
            }
            default -> null;
        };
    }

    @Nullable
    private Click process(@NotNull ClientClickWindowPacket.ClickType type, int slot, byte button) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ClientClickWindowPacket.ClickType.PICKUP -> {
                switch (button) {
                    case 0: {
                        yield new Click.Left(slot);
                    }
                    case 1: {
                        yield new Click.Right(slot);
                    }
                }
                yield null;
            }
            case ClientClickWindowPacket.ClickType.QUICK_MOVE -> {
                if (button == 0) {
                    yield new Click.LeftShift(slot);
                }
                yield new Click.RightShift(slot);
            }
            case ClientClickWindowPacket.ClickType.SWAP -> {
                if (button >= 0 && button < 9) {
                    yield new Click.HotbarSwap(button, slot);
                }
                if (button == 40) {
                    yield new Click.OffhandSwap(slot);
                }
                yield null;
            }
            case ClientClickWindowPacket.ClickType.CLONE -> new Click.Middle(slot);
            case ClientClickWindowPacket.ClickType.THROW -> new Click.DropSlot(slot, button == 1);
            case ClientClickWindowPacket.ClickType.QUICK_CRAFT -> {
                switch (button) {
                    case 1: {
                        this.leftDrag.add(slot);
                        break;
                    }
                    case 5: {
                        this.rightDrag.add(slot);
                        break;
                    }
                    case 9: {
                        this.middleDrag.add(slot);
                    }
                }
                yield null;
            }
            case ClientClickWindowPacket.ClickType.PICKUP_ALL -> new Click.Double(slot);
        };
    }
}

