/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import java.util.Set;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.BlockLight;
import net.minestom.server.instance.light.SkyLight;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface Light {
    public static Light sky() {
        return new SkyLight();
    }

    public static Light block() {
        return new BlockLight();
    }

    public boolean requiresSend();

    @ApiStatus.Internal
    public byte[] array();

    public void flip();

    public int getLevel(int var1, int var2, int var3);

    public void invalidate();

    public boolean requiresUpdate();

    public void set(byte[] var1);

    @ApiStatus.Internal
    public Set<Point> calculateInternal(Palette var1, int var2, int var3, int var4, int[] var5, int var6, LightLookup var7);

    @ApiStatus.Internal
    public Set<Point> calculateExternal(Palette var1, Point[] var2, LightLookup var3, PaletteLookup var4);

    @ApiStatus.Internal
    public static Point[] getNeighbors(Chunk chunk, int sectionY) {
        int chunkX = chunk.getChunkX();
        int chunkZ = chunk.getChunkZ();
        Point[] links = new Vec[BlockFace.values().length];
        for (BlockFace face : BlockFace.values()) {
            Direction direction = face.toDirection();
            int x = chunkX + direction.normalX();
            int z = chunkZ + direction.normalZ();
            int y = sectionY + direction.normalY();
            Chunk foundChunk = chunk.getInstance().getChunk(x, z);
            if (foundChunk == null || y - foundChunk.getMinSection() > foundChunk.getMaxSection() || y - foundChunk.getMinSection() < 0) continue;
            links[face.ordinal()] = new Vec(foundChunk.getChunkX(), y, foundChunk.getChunkZ());
        }
        return links;
    }

    @FunctionalInterface
    public static interface PaletteLookup {
        @Nullable
        public Palette palette(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface LightLookup {
        @Nullable
        public Light light(int var1, int var2, int var3);
    }
}

