/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.golem;

import net.minestom.server.color.DyeColor;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.golem.AbstractGolemMeta;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerMeta
extends AbstractGolemMeta {
    private static final DyeColor[] DYE_VALUES = DyeColor.values();

    public ShulkerMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public Direction getAttachFace() {
        return this.metadata.get(MetadataDef.Shulker.ATTACH_FACE);
    }

    public void setAttachFace(Direction value) {
        this.metadata.set(MetadataDef.Shulker.ATTACH_FACE, value);
    }

    public byte getShieldHeight() {
        return this.metadata.get(MetadataDef.Shulker.SHIELD_HEIGHT);
    }

    public void setShieldHeight(byte value) {
        this.metadata.set(MetadataDef.Shulker.SHIELD_HEIGHT, value);
    }

    @Deprecated
    @NotNull
    public DyeColor getColor() {
        return DYE_VALUES[this.metadata.get(MetadataDef.Shulker.COLOR)];
    }

    @Deprecated
    public void setColor(@NotNull DyeColor value) {
        this.metadata.set(MetadataDef.Shulker.COLOR, (byte)value.ordinal());
    }

    @Override
    @Nullable
    protected <T> T get(@NotNull DataComponent<T> component) {
        if (component == DataComponents.SHULKER_COLOR) {
            return (T)((Object)this.getColor());
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(@NotNull DataComponent<T> component, @NotNull T value) {
        if (component == DataComponents.SHULKER_COLOR) {
            this.setColor((DyeColor)((Object)value));
        } else {
            super.set(component, value);
        }
    }
}

