/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum VillagerType implements StaticProtocolObject<VillagerType>
{
    DESERT("desert"),
    JUNGLE("jungle"),
    PLAINS("plains"),
    SAVANNA("savanna"),
    SNOW("snow"),
    SWAMP("swamp"),
    TAIGA("taiga");

    private static final Map<Key, VillagerType> BY_KEY;
    public static final NetworkBuffer.Type<VillagerType> NETWORK_TYPE;
    public static final Codec<VillagerType> CODEC;
    private final Key key;

    private VillagerType(String key) {
        this.key = Key.key((String)key);
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(VillagerType.values()).collect(Collectors.toUnmodifiableMap(VillagerType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(VillagerType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, VillagerType::key);
    }
}

