/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.util.List;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.NotNull;

public interface TranscoderProxy<D>
extends Transcoder<D> {
    @NotNull
    public static Transcoder<?> extractDelegate(@NotNull Transcoder<?> transcoder) {
        if (transcoder instanceof TranscoderProxy) {
            TranscoderProxy proxy = (TranscoderProxy)transcoder;
            return TranscoderProxy.extractDelegate(proxy.delegate());
        }
        return transcoder;
    }

    @NotNull
    public Transcoder<D> delegate();

    @Override
    @NotNull
    default public D createNull() {
        return this.delegate().createNull();
    }

    @Override
    @NotNull
    default public Result<Boolean> getBoolean(@NotNull D value) {
        return this.delegate().getBoolean(value);
    }

    @Override
    @NotNull
    default public D createBoolean(boolean value) {
        return this.delegate().createBoolean(value);
    }

    @Override
    @NotNull
    default public Result<Byte> getByte(@NotNull D value) {
        return this.delegate().getByte(value);
    }

    @Override
    @NotNull
    default public D createByte(byte value) {
        return this.delegate().createByte(value);
    }

    @Override
    @NotNull
    default public Result<Short> getShort(@NotNull D value) {
        return this.delegate().getShort(value);
    }

    @Override
    @NotNull
    default public D createShort(short value) {
        return this.delegate().createShort(value);
    }

    @Override
    @NotNull
    default public Result<Integer> getInt(@NotNull D value) {
        return this.delegate().getInt(value);
    }

    @Override
    @NotNull
    default public D createInt(int value) {
        return this.delegate().createInt(value);
    }

    @Override
    @NotNull
    default public Result<Long> getLong(@NotNull D value) {
        return this.delegate().getLong(value);
    }

    @Override
    @NotNull
    default public D createLong(long value) {
        return this.delegate().createLong(value);
    }

    @Override
    @NotNull
    default public Result<Float> getFloat(@NotNull D value) {
        return this.delegate().getFloat(value);
    }

    @Override
    @NotNull
    default public D createFloat(float value) {
        return this.delegate().createFloat(value);
    }

    @Override
    @NotNull
    default public Result<Double> getDouble(@NotNull D value) {
        return this.delegate().getDouble(value);
    }

    @Override
    @NotNull
    default public D createDouble(double value) {
        return this.delegate().createDouble(value);
    }

    @Override
    @NotNull
    default public Result<String> getString(@NotNull D value) {
        return this.delegate().getString(value);
    }

    @Override
    @NotNull
    default public D createString(@NotNull String value) {
        return this.delegate().createString(value);
    }

    @Override
    @NotNull
    default public D createByteArray(byte[] value) {
        return this.delegate().createByteArray(value);
    }

    @Override
    @NotNull
    default public Result<byte[]> getByteArray(@NotNull D value) {
        return this.delegate().getByteArray(value);
    }

    @Override
    @NotNull
    default public D createIntArray(int[] value) {
        return this.delegate().createIntArray(value);
    }

    @Override
    @NotNull
    default public Result<int[]> getIntArray(@NotNull D value) {
        return this.delegate().getIntArray(value);
    }

    @Override
    @NotNull
    default public D createLongArray(long[] value) {
        return this.delegate().createLongArray(value);
    }

    @Override
    @NotNull
    default public Result<long[]> getLongArray(@NotNull D value) {
        return this.delegate().getLongArray(value);
    }

    @Override
    @NotNull
    default public Result<List<D>> getList(@NotNull D value) {
        return this.delegate().getList(value);
    }

    @Override
    @NotNull
    default public Result<Transcoder.MapLike<D>> getMap(@NotNull D value) {
        return this.delegate().getMap(value);
    }

    @Override
    @NotNull
    default public Transcoder.MapBuilder<D> createMap() {
        return this.delegate().createMap();
    }

    @Override
    @NotNull
    default public Transcoder.ListBuilder<D> createList(int expectedSize) {
        return this.delegate().createList(expectedSize);
    }

    @Override
    @NotNull
    default public <O> Result<O> convertTo(@NotNull Transcoder<O> coder, @NotNull D value) {
        return this.delegate().convertTo(coder, value);
    }
}

