/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.NumberBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.NotNull;

final class TranscoderNbtImpl
implements Transcoder<BinaryTag> {
    static final TranscoderNbtImpl INSTANCE = new TranscoderNbtImpl();
    private static final Set<String> WRAPPED_ELEMENT_KEYS = Set.of("");

    TranscoderNbtImpl() {
    }

    @Override
    @NotNull
    public BinaryTag createNull() {
        return EndBinaryTag.endBinaryTag();
    }

    @Override
    @NotNull
    public Result<Boolean> getBoolean(@NotNull BinaryTag value) {
        NumberBinaryTag number;
        return value instanceof NumberBinaryTag ? new Result.Ok<Boolean>((number = (NumberBinaryTag)value).byteValue() != 0) : new Result.Error("Not a boolean: " + String.valueOf(value));
    }

    @Override
    @NotNull
    public BinaryTag createBoolean(boolean value) {
        return value ? ByteBinaryTag.ONE : ByteBinaryTag.ZERO;
    }

    @Override
    @NotNull
    public Result<Byte> getByte(@NotNull BinaryTag value) {
        Result.Error<Byte> error;
        if (value instanceof NumberBinaryTag) {
            NumberBinaryTag number = (NumberBinaryTag)value;
            error = new Result.Ok<Byte>(number.byteValue());
        } else {
            error = new Result.Error("Not a byte: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createByte(byte value) {
        if (value == 0) {
            return ByteBinaryTag.ZERO;
        }
        if (value == 1) {
            return ByteBinaryTag.ONE;
        }
        return ByteBinaryTag.byteBinaryTag((byte)value);
    }

    @Override
    @NotNull
    public Result<Short> getShort(@NotNull BinaryTag value) {
        Result.Error<Short> error;
        if (value instanceof NumberBinaryTag) {
            NumberBinaryTag number = (NumberBinaryTag)value;
            error = new Result.Ok<Short>(number.shortValue());
        } else {
            error = new Result.Error("Not a short: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createShort(short value) {
        return ShortBinaryTag.shortBinaryTag((short)value);
    }

    @Override
    @NotNull
    public Result<Integer> getInt(@NotNull BinaryTag value) {
        Result.Error<Integer> error;
        if (value instanceof NumberBinaryTag) {
            NumberBinaryTag number = (NumberBinaryTag)value;
            error = new Result.Ok<Integer>(number.intValue());
        } else {
            error = new Result.Error("Not an int: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createInt(int value) {
        return IntBinaryTag.intBinaryTag((int)value);
    }

    @Override
    @NotNull
    public Result<Long> getLong(@NotNull BinaryTag value) {
        Result.Error<Long> error;
        if (value instanceof NumberBinaryTag) {
            NumberBinaryTag number = (NumberBinaryTag)value;
            error = new Result.Ok<Long>(number.longValue());
        } else {
            error = new Result.Error("Not a long: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createLong(long value) {
        return LongBinaryTag.longBinaryTag((long)value);
    }

    @Override
    @NotNull
    public Result<Float> getFloat(@NotNull BinaryTag value) {
        Result.Error<Float> error;
        if (value instanceof NumberBinaryTag) {
            NumberBinaryTag number = (NumberBinaryTag)value;
            error = new Result.Ok<Float>(Float.valueOf(number.floatValue()));
        } else {
            error = new Result.Error("Not a float: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createFloat(float value) {
        return FloatBinaryTag.floatBinaryTag((float)value);
    }

    @Override
    @NotNull
    public Result<Double> getDouble(@NotNull BinaryTag value) {
        Result.Error<Double> error;
        if (value instanceof NumberBinaryTag) {
            NumberBinaryTag number = (NumberBinaryTag)value;
            error = new Result.Ok<Double>(number.doubleValue());
        } else {
            error = new Result.Error("Not a double: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createDouble(double value) {
        return DoubleBinaryTag.doubleBinaryTag((double)value);
    }

    @Override
    @NotNull
    public Result<String> getString(@NotNull BinaryTag value) {
        Result.Error<String> error;
        if (value instanceof StringBinaryTag) {
            StringBinaryTag string = (StringBinaryTag)value;
            error = new Result.Ok<String>(string.value());
        } else {
            error = new Result.Error("Not a string: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createString(@NotNull String value) {
        return StringBinaryTag.stringBinaryTag((String)value);
    }

    @Override
    @NotNull
    public Result<List<BinaryTag>> getList(@NotNull BinaryTag value) {
        if (!(value instanceof ListBinaryTag)) {
            return new Result.Error<List<BinaryTag>>("Not a list: " + String.valueOf(value));
        }
        final ListBinaryTag listTag = (ListBinaryTag)value;
        return new Result.Ok<List<BinaryTag>>(new AbstractList<BinaryTag>(this){

            @Override
            public BinaryTag get(int index) {
                return listTag.get(index);
            }

            @Override
            public int size() {
                return listTag.size();
            }
        });
    }

    @Override
    @NotNull
    public BinaryTag emptyList() {
        return ListBinaryTag.empty();
    }

    @Override
    @NotNull
    public Transcoder.ListBuilder<BinaryTag> createList(int expectedSize) {
        final ListBinaryTag.Builder elements = ListBinaryTag.heterogeneousListBinaryTag();
        return new Transcoder.ListBuilder<BinaryTag>(this){

            @Override
            @NotNull
            public Transcoder.ListBuilder<BinaryTag> add(BinaryTag value) {
                elements.add(value);
                return this;
            }

            @Override
            public BinaryTag build() {
                return elements.build();
            }
        };
    }

    @Override
    @NotNull
    public Result<Transcoder.MapLike<BinaryTag>> getMap(@NotNull BinaryTag value) {
        if (!(value instanceof CompoundBinaryTag)) {
            return new Result.Error<Transcoder.MapLike<BinaryTag>>("Not a compound: " + String.valueOf(value));
        }
        final CompoundBinaryTag compoundTag = (CompoundBinaryTag)value;
        return new Result.Ok<Transcoder.MapLike<BinaryTag>>(new Transcoder.MapLike<BinaryTag>(this){

            @Override
            @NotNull
            public Collection<String> keys() {
                return compoundTag.keySet();
            }

            @Override
            public boolean hasValue(@NotNull String key) {
                return compoundTag.get(key) != null;
            }

            @Override
            @NotNull
            public Result<BinaryTag> getValue(@NotNull String key) {
                BinaryTag tag = compoundTag.get(key);
                if (tag == null) {
                    return new Result.Error<BinaryTag>("No such key: " + key);
                }
                return new Result.Ok<BinaryTag>(tag);
            }

            @Override
            public int size() {
                return compoundTag.size();
            }
        });
    }

    @Override
    @NotNull
    public BinaryTag emptyMap() {
        return CompoundBinaryTag.empty();
    }

    @Override
    @NotNull
    public Transcoder.MapBuilder<BinaryTag> createMap() {
        final CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        return new Transcoder.MapBuilder<BinaryTag>(this){

            @Override
            @NotNull
            public Transcoder.MapBuilder<BinaryTag> put(@NotNull BinaryTag key, BinaryTag value) {
                if (!(value instanceof EndBinaryTag) && key instanceof StringBinaryTag) {
                    StringBinaryTag string = (StringBinaryTag)key;
                    builder.put(string.value(), value);
                }
                return this;
            }

            @Override
            @NotNull
            public Transcoder.MapBuilder<BinaryTag> put(@NotNull String key, BinaryTag value) {
                if (!(value instanceof EndBinaryTag)) {
                    builder.put(key, value);
                }
                return this;
            }

            @Override
            public BinaryTag build() {
                return builder.build();
            }
        };
    }

    @Override
    @NotNull
    public Result<byte[]> getByteArray(@NotNull BinaryTag value) {
        Result.Error<byte[]> error;
        if (value instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArray = (ByteArrayBinaryTag)value;
            error = new Result.Ok<byte[]>(byteArray.value());
        } else {
            error = new Result.Error("Not a byte array: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createByteArray(byte[] value) {
        return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])value);
    }

    @Override
    @NotNull
    public Result<int[]> getIntArray(@NotNull BinaryTag value) {
        Result.Error<int[]> error;
        if (value instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArray = (IntArrayBinaryTag)value;
            error = new Result.Ok<int[]>(intArray.value());
        } else {
            error = new Result.Error("Not an int array: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createIntArray(int[] value) {
        return IntArrayBinaryTag.intArrayBinaryTag((int[])value);
    }

    @Override
    @NotNull
    public Result<long[]> getLongArray(@NotNull BinaryTag value) {
        Result.Error<long[]> error;
        if (value instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArray = (LongArrayBinaryTag)value;
            error = new Result.Ok<long[]>(longArray.value());
        } else {
            error = new Result.Error("Not a long array: " + String.valueOf(value));
        }
        return error;
    }

    @Override
    @NotNull
    public BinaryTag createLongArray(long[] value) {
        return LongArrayBinaryTag.longArrayBinaryTag((long[])value);
    }

    @Override
    @NotNull
    public <O> Result<O> convertTo(@NotNull Transcoder<O> coder, @NotNull BinaryTag value) {
        BinaryTag binaryTag = value;
        Objects.requireNonNull(binaryTag);
        BinaryTag binaryTag2 = binaryTag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EndBinaryTag.class, ByteBinaryTag.class, ShortBinaryTag.class, IntBinaryTag.class, LongBinaryTag.class, FloatBinaryTag.class, DoubleBinaryTag.class, ByteArrayBinaryTag.class, StringBinaryTag.class, ListBinaryTag.class, CompoundBinaryTag.class, IntArrayBinaryTag.class, LongArrayBinaryTag.class}, (Object)binaryTag2, n)) {
            case 0 -> {
                EndBinaryTag ignored = (EndBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createNull());
            }
            case 1 -> {
                ByteBinaryTag byteTag = (ByteBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createByte(byteTag.byteValue()));
            }
            case 2 -> {
                ShortBinaryTag shortTag = (ShortBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createShort(shortTag.shortValue()));
            }
            case 3 -> {
                IntBinaryTag intTag = (IntBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createInt(intTag.intValue()));
            }
            case 4 -> {
                LongBinaryTag longTag = (LongBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createLong(longTag.longValue()));
            }
            case 5 -> {
                FloatBinaryTag floatTag = (FloatBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createFloat(floatTag.floatValue()));
            }
            case 6 -> {
                DoubleBinaryTag doubleTag = (DoubleBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createDouble(doubleTag.doubleValue()));
            }
            case 7 -> {
                ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createByteArray(byteArrayTag.value()));
            }
            case 8 -> {
                StringBinaryTag stringTag = (StringBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createString(stringTag.value()));
            }
            case 9 -> {
                ListBinaryTag listTag = (ListBinaryTag)binaryTag2;
                Transcoder.ListBuilder<O> list = coder.createList(listTag.size());
                block23: for (int i = 0; i < listTag.size(); ++i) {
                    Result<O> var17_20;
                    Objects.requireNonNull(this.convertTo(coder, listTag.get(i)));
                    int var18_23 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, var17_20, var18_23)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            Result.Ok ok = (Result.Ok)var17_20;
                            list.add(ok.value());
                            continue block23;
                        }
                        case 1: {
                            Result.Error error = (Result.Error)var17_20;
                            yield new Result.Error(i + ": " + String.valueOf(error));
                        }
                    }
                }
                yield new Result.Ok<O>(list.build());
            }
            case 10 -> {
                CompoundBinaryTag compoundTag = (CompoundBinaryTag)binaryTag2;
                Transcoder.MapBuilder<O> map = coder.createMap();
                block24: for (Map.Entry entry : compoundTag) {
                    Result<O> var19_26;
                    Objects.requireNonNull(this.convertTo(coder, (BinaryTag)entry.getValue()));
                    int var20_28 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, var19_26, var20_28)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            Result.Ok ok = (Result.Ok)var19_26;
                            map.put(coder.createString((String)entry.getKey()), ok.value());
                            continue block24;
                        }
                        case 1: 
                    }
                    Result.Error error = (Result.Error)var19_26;
                    yield new Result.Error((String)entry.getKey() + ": " + String.valueOf(error));
                }
                yield new Result.Ok<O>(map.build());
            }
            case 11 -> {
                IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createIntArray(intArrayTag.value()));
            }
            case 12 -> {
                LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)binaryTag2;
                yield new Result.Ok<O>(coder.createLongArray(longArrayTag.value()));
            }
            default -> new Result.Error("Unsupported type: " + String.valueOf(value));
        };
    }
}

