/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.NotNull;

final class TranscoderJavaImpl
implements Transcoder<Object> {
    public static final Transcoder<Object> INSTANCE = new TranscoderJavaImpl();

    TranscoderJavaImpl() {
    }

    @Override
    @NotNull
    public Object createNull() {
        return Optional.empty();
    }

    @Override
    @NotNull
    public Result<Boolean> getBoolean(@NotNull Object value) {
        if (!(value instanceof Boolean)) {
            return new Result.Error<Boolean>("Not a boolean: " + String.valueOf(value));
        }
        Boolean b = (Boolean)value;
        return new Result.Ok<Boolean>(b);
    }

    @Override
    @NotNull
    public Object createBoolean(boolean value) {
        return value;
    }

    @Override
    @NotNull
    public Result<Byte> getByte(@NotNull Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Byte>("Not a byte: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Byte>(n.byteValue());
    }

    @Override
    @NotNull
    public Object createByte(byte value) {
        return value;
    }

    @Override
    @NotNull
    public Result<Short> getShort(@NotNull Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Short>("Not a short: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Short>(n.shortValue());
    }

    @Override
    @NotNull
    public Object createShort(short value) {
        return value;
    }

    @Override
    @NotNull
    public Result<Integer> getInt(@NotNull Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Integer>("Not an int: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Integer>(n.intValue());
    }

    @Override
    @NotNull
    public Object createInt(int value) {
        return value;
    }

    @Override
    @NotNull
    public Result<Long> getLong(@NotNull Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Long>("Not a long: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Long>(n.longValue());
    }

    @Override
    @NotNull
    public Object createLong(long value) {
        return value;
    }

    @Override
    @NotNull
    public Result<Float> getFloat(@NotNull Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Float>("Not a float: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Float>(Float.valueOf(n.floatValue()));
    }

    @Override
    @NotNull
    public Object createFloat(float value) {
        return Float.valueOf(value);
    }

    @Override
    @NotNull
    public Result<Double> getDouble(@NotNull Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Double>("Not a double: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Double>(n.doubleValue());
    }

    @Override
    @NotNull
    public Object createDouble(double value) {
        return value;
    }

    @Override
    @NotNull
    public Result<String> getString(@NotNull Object value) {
        if (!(value instanceof String)) {
            return new Result.Error<String>("Not a string: " + String.valueOf(value));
        }
        String s = (String)value;
        return new Result.Ok<String>(s);
    }

    @Override
    @NotNull
    public Object createString(@NotNull String value) {
        return value;
    }

    @Override
    @NotNull
    public Result<List<Object>> getList(@NotNull Object value) {
        if (!(value instanceof List)) {
            return new Result.Error<List<Object>>("Not a list: " + String.valueOf(value));
        }
        List list = (List)value;
        return new Result.Ok<List<Object>>(list);
    }

    @Override
    @NotNull
    public Transcoder.ListBuilder<Object> createList(int expectedSize) {
        final ArrayList list = new ArrayList(expectedSize);
        return new Transcoder.ListBuilder<Object>(this){

            @Override
            @NotNull
            public Transcoder.ListBuilder<Object> add(Object value) {
                list.add(value);
                return this;
            }

            @Override
            public Object build() {
                return List.copyOf(list);
            }
        };
    }

    @Override
    @NotNull
    public Result<Transcoder.MapLike<Object>> getMap(@NotNull Object value) {
        if (!(value instanceof Map)) {
            return new Result.Error<Transcoder.MapLike<Object>>("Not a map: " + String.valueOf(value));
        }
        final Map map = (Map)value;
        return new Result.Ok<Transcoder.MapLike<Object>>(new Transcoder.MapLike<Object>(this){

            @Override
            @NotNull
            public Collection<String> keys() {
                if (map.isEmpty()) {
                    return List.of();
                }
                List<String> keys = List.copyOf(map.keySet());
                if (keys.getFirst() instanceof String) {
                    return keys;
                }
                return List.of();
            }

            @Override
            public boolean hasValue(@NotNull String key) {
                return map.containsKey(key);
            }

            @Override
            @NotNull
            public Result<Object> getValue(@NotNull String key) {
                if (!this.hasValue(key)) {
                    return new Result.Error<Object>("No such key: " + key);
                }
                return new Result.Ok<Object>(map.get(key));
            }
        });
    }

    @Override
    @NotNull
    public Transcoder.MapBuilder<Object> createMap() {
        final HashMap map = new HashMap();
        return new Transcoder.MapBuilder<Object>(this){

            @Override
            @NotNull
            public Transcoder.MapBuilder<Object> put(@NotNull Object key, Object value) {
                if (!(key instanceof String)) {
                    return this;
                }
                String s = (String)key;
                map.put(s, value);
                return this;
            }

            @Override
            @NotNull
            public Transcoder.MapBuilder<Object> put(@NotNull String key, Object value) {
                map.put(key, value);
                return this;
            }

            @Override
            public Object build() {
                return Map.copyOf(map);
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public <O> Result<O> convertTo(@NotNull Transcoder<O> coder, @NotNull Object value) {
        Result<Object> result;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Optional.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, String.class, List.class, Map.class}, (Object)object2, n)) {
                case 0: {
                    Optional o = (Optional)object2;
                    if (o.isEmpty()) {
                        result = new Result.Ok<O>(coder.createNull());
                        return result;
                    }
                    n = 1;
                    continue block17;
                }
                case 1: {
                    Boolean b = (Boolean)object2;
                    result = new Result.Ok<O>(coder.createBoolean(b));
                    return result;
                }
                case 2: {
                    Byte n2 = (Byte)object2;
                    result = new Result.Ok<O>(coder.createByte(n2));
                    return result;
                }
                case 3: {
                    Short n3 = (Short)object2;
                    result = new Result.Ok<O>(coder.createShort(n3));
                    return result;
                }
                case 4: {
                    Integer n4 = (Integer)object2;
                    result = new Result.Ok<O>(coder.createInt(n4));
                    return result;
                }
                case 5: {
                    Long n5 = (Long)object2;
                    result = new Result.Ok<O>(coder.createLong(n5));
                    return result;
                }
                case 6: {
                    Float n6 = (Float)object2;
                    result = new Result.Ok<O>(coder.createFloat(n6.floatValue()));
                    return result;
                }
                case 7: {
                    Double n7 = (Double)object2;
                    result = new Result.Ok<O>(coder.createDouble(n7));
                    return result;
                }
                case 8: {
                    Number n8 = (Number)object2;
                    result = new Result.Ok<O>(coder.createDouble(n8.doubleValue()));
                    return result;
                }
                case 9: {
                    String s = (String)object2;
                    result = new Result.Ok<O>(coder.createString(s));
                    return result;
                }
                case 10: {
                    List l = (List)object2;
                    Transcoder.ListBuilder<O> builder = coder.createList(l.size());
                    Iterator iterator = l.iterator();
                    while (true) {
                        Object inner;
                        if (!iterator.hasNext()) {
                            result = new Result.Ok<O>(builder.build());
                            return result;
                        }
                        Object o = iterator.next();
                        Result<O> result2 = this.convertTo(coder, o);
                        if (!(result2 instanceof Result.Ok)) {
                            result = result2.cast();
                            return result;
                        }
                        Result.Ok ok = (Result.Ok)result2;
                        try {
                            Object t;
                            inner = t = ok.value();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        builder.add(inner);
                    }
                }
                case 11: {
                    Map m = (Map)object2;
                    Transcoder.MapBuilder<O> builder = coder.createMap();
                    Iterator iterator = m.entrySet().iterator();
                    while (true) {
                        Object inner;
                        if (!iterator.hasNext()) {
                            result = new Result.Ok<O>(builder.build());
                            return result;
                        }
                        Map.Entry entry = iterator.next();
                        Object key = entry.getKey();
                        if (!(key instanceof String)) {
                            result = new Result.Error("Map key is not a string: " + String.valueOf(key));
                            return result;
                        }
                        String s = (String)key;
                        Result<O> result3 = this.convertTo(coder, entry.getValue());
                        if (!(result3 instanceof Result.Ok)) {
                            result = result3.cast();
                            return result;
                        }
                        Result.Ok ok = (Result.Ok)result3;
                        {
                            Object t;
                            inner = t = ok.value();
                        }
                        builder.put(s, inner);
                    }
                }
            }
            break;
        }
        result = new Result.Error("Unsupported type: " + String.valueOf(value));
        return result;
    }
}

