/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.TranscoderCrc32Impl;
import net.minestom.server.codec.TranscoderJavaImpl;
import net.minestom.server.codec.TranscoderJsonImpl;
import net.minestom.server.codec.TranscoderNbtImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface Transcoder<D> {
    @NotNull
    public static final Transcoder<BinaryTag> NBT = TranscoderNbtImpl.INSTANCE;
    @NotNull
    public static final Transcoder<JsonElement> JSON = TranscoderJsonImpl.INSTANCE;
    @NotNull
    public static final Transcoder<Object> JAVA = TranscoderJavaImpl.INSTANCE;
    @NotNull
    public static final Transcoder<Integer> CRC32_HASH = TranscoderCrc32Impl.INSTANCE;

    @NotNull
    public D createNull();

    @NotNull
    public Result<Boolean> getBoolean(@NotNull D var1);

    @NotNull
    public D createBoolean(boolean var1);

    @NotNull
    public Result<Byte> getByte(@NotNull D var1);

    @NotNull
    public D createByte(byte var1);

    @NotNull
    public Result<Short> getShort(@NotNull D var1);

    @NotNull
    public D createShort(short var1);

    @NotNull
    public Result<Integer> getInt(@NotNull D var1);

    @NotNull
    public D createInt(int var1);

    @NotNull
    public Result<Long> getLong(@NotNull D var1);

    @NotNull
    public D createLong(long var1);

    @NotNull
    public Result<Float> getFloat(@NotNull D var1);

    @NotNull
    public D createFloat(float var1);

    @NotNull
    public Result<Double> getDouble(@NotNull D var1);

    @NotNull
    public D createDouble(double var1);

    @NotNull
    public Result<String> getString(@NotNull D var1);

    @NotNull
    public D createString(@NotNull String var1);

    @NotNull
    public Result<List<D>> getList(@NotNull D var1);

    @NotNull
    default public D emptyList() {
        return this.createList(0).build();
    }

    @NotNull
    public ListBuilder<D> createList(int var1);

    @NotNull
    public Result<MapLike<D>> getMap(@NotNull D var1);

    @NotNull
    default public D emptyMap() {
        return this.createMap().build();
    }

    @NotNull
    public MapBuilder<D> createMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    default public Result<byte[]> getByteArray(@NotNull D value) {
        List list;
        Result<List<D>> listResult = this.getList(value);
        if (!(listResult instanceof Result.Ok)) return listResult.cast();
        Result.Ok ok = (Result.Ok)listResult;
        try {
            List list2;
            list = list2 = (List)ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        byte[] byteArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Byte by;
            Result<Byte> byteResult = this.getByte(list.get(i));
            if (!(byteResult instanceof Result.Ok)) return byteResult.cast();
            ok = (Result.Ok)byteResult;
            Byte byteValue = by = (Byte)ok.value();
            byteArray[i] = byteValue;
        }
        return new Result.Ok<byte[]>(byteArray);
    }

    @NotNull
    default public D createByteArray(byte[] value) {
        ListBuilder<D> list = this.createList(value.length);
        for (byte b : value) {
            list.add(this.createByte(b));
        }
        return list.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    default public Result<int[]> getIntArray(@NotNull D value) {
        List list;
        Result<List<D>> listResult = this.getList(value);
        if (!(listResult instanceof Result.Ok)) return listResult.cast();
        Result.Ok ok = (Result.Ok)listResult;
        try {
            List list2;
            list = list2 = (List)ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        int[] intArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n;
            Result<Integer> intResult = this.getInt(list.get(i));
            if (!(intResult instanceof Result.Ok)) return intResult.cast();
            ok = (Result.Ok)intResult;
            Integer intValue = n = (Integer)ok.value();
            intArray[i] = intValue;
        }
        return new Result.Ok<int[]>(intArray);
    }

    @NotNull
    default public D createIntArray(int[] value) {
        ListBuilder<D> list = this.createList(value.length);
        for (int i : value) {
            list.add(this.createInt(i));
        }
        return list.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    default public Result<long[]> getLongArray(@NotNull D value) {
        List list;
        Result<List<D>> listResult = this.getList(value);
        if (!(listResult instanceof Result.Ok)) return listResult.cast();
        Result.Ok ok = (Result.Ok)listResult;
        try {
            List list2;
            list = list2 = (List)ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        long[] longArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Long l;
            Result<Long> longResult = this.getLong(list.get(i));
            if (!(longResult instanceof Result.Ok)) return longResult.cast();
            ok = (Result.Ok)longResult;
            Long longValue = l = (Long)ok.value();
            longArray[i] = longValue;
        }
        return new Result.Ok<long[]>(longArray);
    }

    @NotNull
    default public D createLongArray(long[] value) {
        ListBuilder<D> list = this.createList(value.length);
        for (long l : value) {
            list.add(this.createLong(l));
        }
        return list.build();
    }

    @NotNull
    public <O> Result<O> convertTo(@NotNull Transcoder<O> var1, @NotNull D var2);

    public static interface ListBuilder<D> {
        @NotNull
        public ListBuilder<D> add(D var1);

        public D build();
    }

    public static interface MapBuilder<D> {
        @NotNull
        public MapBuilder<D> put(@NotNull D var1, D var2);

        @NotNull
        public MapBuilder<D> put(@NotNull String var1, D var2);

        public D build();
    }

    public static interface MapLike<D> {
        @NotNull
        public Collection<String> keys();

        public boolean hasValue(@NotNull String var1);

        @NotNull
        public Result<D> getValue(@NotNull String var1);

        default public int size() {
            return this.keys().size();
        }

        default public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

