/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryCodecs;
import net.minestom.server.registry.RegistryKeyImpl;
import net.minestom.server.registry.RegistryNetworkTypes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface RegistryKey<T>
extends Holder<T>,
Keyed {
    public static <T> @NotNull NetworkBuffer.Type<RegistryKey<T>> networkType(@NotNull Registries.Selector<T> selector) {
        return new RegistryNetworkTypes.RegistryKeyImpl<T>(selector);
    }

    @NotNull
    public static <T> Codec<RegistryKey<T>> codec(@NotNull Registries.Selector<T> selector) {
        return new RegistryCodecs.RegistryKeyImpl<T>(selector);
    }

    public static <T> @NotNull NetworkBuffer.Type<RegistryKey<T>> uncheckedNetworkType() {
        return NetworkBuffer.KEY.transform(RegistryKeyImpl::new, Keyed::key);
    }

    @NotNull
    public static <T> Codec<RegistryKey<T>> uncheckedCodec() {
        return Codec.KEY.transform(RegistryKeyImpl::new, Keyed::key);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> RegistryKey<T> unsafeOf(@NotNull String key) {
        return RegistryKey.unsafeOf(Key.key((String)key));
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> RegistryKey<T> unsafeOf(@NotNull Key key) {
        return new RegistryKeyImpl(key);
    }

    @NotNull
    default public String name() {
        return this.key().asString();
    }
}

