/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.minestom.server.MinecraftServer;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockSoundType;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.Equippable;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryTagImpl;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.registry.StaticRegistry;
import net.minestom.server.registry.TagKey;
import net.minestom.server.registry.TagKeyImpl;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.collection.ObjectArray;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class RegistryData {
    static final Gson GSON = new GsonBuilder().disableHtmlEscaping().disableJdkUnsafe().create();

    @ApiStatus.Internal
    public static BlockEntry block(String namespace, @NotNull Properties main) {
        return new BlockEntry(namespace, main, new HashMap<Object, Object>(), null, null);
    }

    @ApiStatus.Internal
    public static BlockEntry block(String namespace, @NotNull Properties main, HashMap<Object, Object> internCache, @Nullable BlockEntry parent, @Nullable Properties parentProperties) {
        return new BlockEntry(namespace, main, internCache, parent, parentProperties);
    }

    @ApiStatus.Internal
    public static MaterialEntry material(String namespace, @NotNull Properties main) {
        return new MaterialEntry(namespace, main);
    }

    @ApiStatus.Internal
    public static EntityEntry entity(String namespace, @NotNull Properties main) {
        return new EntityEntry(namespace, main);
    }

    @ApiStatus.Internal
    public static VillagerProfessionEntry villagerProfession(String namespace, @NotNull Properties main) {
        return new VillagerProfessionEntry(namespace, main);
    }

    @ApiStatus.Internal
    public static FeatureFlagEntry featureFlag(String namespace, @NotNull Properties main) {
        return new FeatureFlagEntry(namespace, main);
    }

    @ApiStatus.Internal
    public static FluidEntry fluid(String namespace, @NotNull Properties main) {
        return new FluidEntry(namespace, main);
    }

    @ApiStatus.Internal
    public static PotionEffectEntry potionEffect(String namespace, @NotNull Properties main) {
        return new PotionEffectEntry(namespace, main);
    }

    @ApiStatus.Internal
    public static AttributeEntry attribute(String namespace, @NotNull Properties main) {
        return new AttributeEntry(namespace, main);
    }

    public static GameEventEntry gameEventEntry(String namespace, Properties properties) {
        return new GameEventEntry(namespace, properties);
    }

    public static BlockSoundTypeEntry blockSoundTypeEntry(String namespace, Properties properties) {
        return new BlockSoundTypeEntry(namespace, properties);
    }

    @Nullable
    public static InputStream loadRegistryFile(@NotNull String path) throws IOException {
        InputStream resourceStream = RegistryData.class.getClassLoader().getResourceAsStream(path);
        Path filesystemPath = Path.of(path, new String[0]);
        if (resourceStream == null && Files.exists(filesystemPath, new LinkOption[0])) {
            resourceStream = Files.newInputStream(filesystemPath, new OpenOption[0]);
        }
        return resourceStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Internal
    public static Properties load(String resourcePath, boolean required) {
        block14: {
            try (InputStream resourceStream = RegistryData.loadRegistryFile(resourcePath);){
                if (resourceStream == null) break block14;
                HashMap<String, Object> map = new HashMap<String, Object>();
                try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceStream));){
                    reader.beginObject();
                    while (reader.hasNext()) {
                        map.put(reader.nextName(), RegistryData.readObject(reader));
                    }
                    reader.endObject();
                }
                Properties properties = Properties.fromMap(map);
                return properties;
            }
            catch (IOException e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
        }
        if (!required) return Properties.fromMap(Map.of());
        Check.fail("Failed to load required registry file: {0}", resourcePath);
        return Properties.fromMap(Map.of());
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends StaticProtocolObject<T>> Registry<T> createStaticRegistry(@NotNull Key registryKey, @NotNull Loader<T> loader) {
        Properties entries = RegistryData.load(String.format("%s.json", registryKey.value()), true);
        HashMap<Key, T> namespaces = new HashMap<Key, T>(entries.size());
        ObjectArray<T> ids = ObjectArray.singleThread(entries.size());
        for (String entry : entries.asMap().keySet()) {
            Properties properties = entries.section(entry);
            T value = loader.get(entry, properties);
            ids.set(value.id(), value);
            namespaces.put(value.key(), value);
        }
        Map<TagKey<T>, RegistryTagImpl.Backed<T>> tags = RegistryData.loadTags(registryKey);
        return new StaticRegistry(registryKey, namespaces, ids, tags);
    }

    @ApiStatus.Internal
    static <T> @Unmodifiable Map<TagKey<T>, RegistryTagImpl.Backed<T>> loadTags(@NotNull Key registryKey) {
        Properties tagJson = RegistryData.load(String.format("tags/%s.json", registryKey.value()), false);
        HashMap<TagKey, RegistryTagImpl.Backed> tags = new HashMap<TagKey, RegistryTagImpl.Backed>(tagJson.size());
        for (String tagName : tagJson.asMap().keySet()) {
            TagKeyImpl tagKey = new TagKeyImpl(Key.key((String)tagName));
            RegistryTagImpl.Backed tagValue = tags.computeIfAbsent(tagKey, RegistryTagImpl.Backed::new);
            RegistryData.getTagValues(tagValue, tagJson, tagName);
        }
        return Map.copyOf(tags);
    }

    private static <T> void getTagValues(@NotNull RegistryTagImpl.Backed<T> tag, Properties main, String value) {
        Properties section = main.section(value);
        List<String> tagValues = section.getList("values");
        tagValues.forEach(tagString -> {
            if (tagString.startsWith("#")) {
                RegistryData.getTagValues(tag, main, tagString.substring(1));
            } else {
                tag.add(RegistryKey.unsafeOf(tagString));
            }
        });
    }

    private static Object readObject(JsonReader reader) throws IOException {
        return switch (reader.peek()) {
            case JsonToken.BEGIN_ARRAY -> {
                ArrayList<Object> list = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    list.add(RegistryData.readObject(reader));
                }
                reader.endArray();
                yield List.copyOf(list);
            }
            case JsonToken.BEGIN_OBJECT -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    map.put(reader.nextName(), RegistryData.readObject(reader));
                }
                reader.endObject();
                yield Map.copyOf(map);
            }
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> ToNumberPolicy.LONG_OR_DOUBLE.readNumber(reader);
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            default -> throw new IllegalStateException("Invalid peek: " + String.valueOf(reader.peek()));
        };
    }

    public static final class BlockEntry
    implements Entry {
        private static final byte AIR_OFFSET = 1;
        private static final byte LIQUID_OFFSET = 2;
        private static final byte SOLID_OFFSET = 4;
        private static final byte OCCLUDES_OFFSET = 8;
        private static final byte REQUIRES_TOOL_OFFSET = 16;
        private static final byte REPLACEABLE_OFFSET = 32;
        private static final byte REDSTONE_CONDUCTOR_OFFSET = 64;
        private static final byte SIGNAL_SOURCE_OFFSET = -128;
        private final Key key;
        private final int id;
        private final int stateId;
        private final String translationKey;
        private final float hardness;
        private final float explosionResistance;
        private final float friction;
        private final float speedFactor;
        private final float jumpFactor;
        private final byte packedFlags;
        private final byte lightEmission;
        @Nullable
        private final Key blockEntity;
        private final int blockEntityId;
        @Nullable
        private final Material material;
        @Nullable
        private final BlockSoundType blockSoundType;
        private final Shape shape;

        private BlockEntry(String namespace, Properties main, @NotNull Map<Object, Object> internCache, @Nullable BlockEntry parent, @Nullable Properties parentProperties) {
            assert (parent == null || !main.asMap().isEmpty()) : "BlockEntry cannot be empty if it has a parent";
            this.key = parent != null ? parent.key : Key.key((String)namespace);
            this.id = BlockEntry.fromParent(parent, BlockEntry::id, main, "id", Properties::getInt, null);
            this.stateId = BlockEntry.fromParent(parent, BlockEntry::stateId, main, "stateId", Properties::getInt, 0);
            this.translationKey = BlockEntry.fromParent(parent, BlockEntry::translationKey, main, "translationKey", Properties::getString, null);
            this.hardness = ((Float)BlockEntry.fromParent(parent, BlockEntry::hardness, main, "hardness", Properties::getFloat, null)).floatValue();
            this.explosionResistance = ((Float)BlockEntry.fromParent(parent, BlockEntry::explosionResistance, main, "explosionResistance", Properties::getFloat, null)).floatValue();
            this.friction = BlockEntry.fromParent(parent, BlockEntry::friction, main, "friction", Properties::getFloat, Float.valueOf(0.6f)).floatValue();
            this.speedFactor = BlockEntry.fromParent(parent, BlockEntry::speedFactor, main, "speedFactor", Properties::getFloat, Float.valueOf(1.0f)).floatValue();
            this.jumpFactor = BlockEntry.fromParent(parent, BlockEntry::jumpFactor, main, "jumpFactor", Properties::getFloat, Float.valueOf(1.0f)).floatValue();
            Boolean air = BlockEntry.fromParent(parent, BlockEntry::isAir, main, "air", Properties::getBoolean, false);
            Boolean solid = BlockEntry.fromParent(parent, BlockEntry::isSolid, main, "solid", Properties::getBoolean, null);
            Boolean liquid = BlockEntry.fromParent(parent, BlockEntry::isLiquid, main, "liquid", Properties::getBoolean, false);
            Boolean occludes = BlockEntry.fromParent(parent, BlockEntry::occludes, main, "occludes", Properties::getBoolean, true);
            Boolean requiresTool = BlockEntry.fromParent(parent, BlockEntry::requiresTool, main, "requiresTool", Properties::getBoolean, true);
            this.lightEmission = BlockEntry.fromParent(parent, BlockEntry::lightEmission, main, "lightEmission", Properties::getInt, 0).byteValue();
            Boolean replaceable = BlockEntry.fromParent(parent, BlockEntry::isReplaceable, main, "replaceable", Properties::getBoolean, false);
            this.blockSoundType = BlockEntry.fromParent(parent, BlockEntry::getBlockSoundType, main, "soundType", (properties, string) -> {
                String soundTypeKey = properties.getString((String)string);
                return soundTypeKey != null ? BlockSoundType.fromKey(soundTypeKey) : null;
            }, null);
            Properties blockEntity = main.section("blockEntity");
            Key blockEntityKey = BlockEntry.fromParent(parent, BlockEntry::blockEntity, blockEntity, "namespace", (properties, string) -> Key.key((String)properties.getString((String)string)), null);
            this.blockEntity = blockEntityKey != null ? (Key)internCache.computeIfAbsent(blockEntityKey, key -> blockEntityKey) : null;
            this.blockEntityId = BlockEntry.fromParent(parent, BlockEntry::blockEntityId, blockEntity, "id", Properties::getInt, 0);
            this.material = BlockEntry.fromParent(parent, BlockEntry::material, main, "correspondingItem", (properties, string) -> {
                String materialNamespace = properties.getString((String)string);
                return materialNamespace != null ? Material.fromKey(materialNamespace) : null;
            }, null);
            this.shape = BlockEntry.fromParent(parent, BlockEntry::collisionShape, main, "collisionShape", (properties, string) -> {
                String collision = properties.getString((String)string);
                String occlusion = properties.getString("occlusionShape");
                if (parent == null || parentProperties == null) {
                    return CollisionUtils.parseBlockShape(internCache, collision, occlusion, occludes, this.lightEmission);
                }
                if (collision != null || occlusion != null || occludes.booleanValue() != parent.occludes() || this.lightEmission != parent.lightEmission) {
                    if (collision == null) {
                        collision = parentProperties.getString((String)string);
                    }
                    if (occlusion == null) {
                        occlusion = parentProperties.getString("occlusionShape");
                    }
                    return CollisionUtils.parseBlockShape(internCache, collision, occlusion, occludes, this.lightEmission);
                }
                return parent.collisionShape();
            }, null);
            Boolean redstoneConductor = BlockEntry.fromParent(parent, BlockEntry::isRedstoneConductor, main, "redstoneConductor", Properties::getBoolean, null);
            Boolean signalSource = BlockEntry.fromParent(parent, BlockEntry::isSignalSource, main, "signalSource", Properties::getBoolean, false);
            this.packedFlags = (byte)((air != false ? 1 : 0) | (liquid != false ? 2 : 0) | (solid != false ? 4 : 0) | (occludes != false ? 8 : 0) | (requiresTool != false ? 16 : 0) | (replaceable != false ? 32 : 0) | (redstoneConductor != false ? 64 : 0) | (signalSource != false ? -128 : 0));
        }

        private static <R> R fromParent(@Nullable BlockEntry parent, @NotNull Function<BlockEntry, R> parentProperty, @Nullable Properties main, @NotNull String name, @NotNull BiFunction<Properties, String, R> function, @Nullable R defaultValue) {
            R value = null;
            if (main != null && main.containsKey(name)) {
                value = function.apply(main, name);
            }
            if (value == null) {
                value = parent != null ? (R)parentProperty.apply(parent) : (R)defaultValue;
            }
            if (value != defaultValue) {
                Check.notNull(value, "{0}->{1} cannot be null", parent, name);
            }
            return value;
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        public int stateId() {
            return this.stateId;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public float hardness() {
            return this.hardness;
        }

        public float explosionResistance() {
            return this.explosionResistance;
        }

        public float friction() {
            return this.friction;
        }

        public float speedFactor() {
            return this.speedFactor;
        }

        public float jumpFactor() {
            return this.jumpFactor;
        }

        public boolean isAir() {
            return (this.packedFlags & 1) != 0;
        }

        public boolean isSolid() {
            return (this.packedFlags & 4) != 0;
        }

        public boolean isLiquid() {
            return (this.packedFlags & 2) != 0;
        }

        public boolean occludes() {
            return (this.packedFlags & 8) != 0;
        }

        public boolean requiresTool() {
            return (this.packedFlags & 0x10) != 0;
        }

        public int lightEmission() {
            return this.lightEmission;
        }

        public boolean isReplaceable() {
            return (this.packedFlags & 0x20) != 0;
        }

        public boolean isBlockEntity() {
            return this.blockEntity != null;
        }

        @Nullable
        public Key blockEntity() {
            return this.blockEntity;
        }

        public int blockEntityId() {
            return this.blockEntityId;
        }

        @Nullable
        public Material material() {
            return this.material;
        }

        public boolean isRedstoneConductor() {
            return (this.packedFlags & 0x40) != 0;
        }

        public boolean isSignalSource() {
            return (this.packedFlags & 0xFFFFFF80) != 0;
        }

        public Shape collisionShape() {
            return this.shape;
        }

        @Nullable
        public BlockSoundType getBlockSoundType() {
            return this.blockSoundType;
        }
    }

    public static interface Properties
    extends Iterable<Map.Entry<String, Object>> {
        public static Properties fromMap(Map<String, Object> map) {
            return new PropertiesMap(map);
        }

        public String getString(String var1, String var2);

        public String getString(String var1);

        public double getDouble(String var1, double var2);

        public double getDouble(String var1);

        public int getInt(String var1, int var2);

        public int getInt(String var1);

        public float getFloat(String var1, float var2);

        public float getFloat(String var1);

        public boolean getBoolean(String var1, boolean var2);

        public boolean getBoolean(String var1);

        public <T> List<T> getList(String var1, List<T> var2);

        @NotNull
        default public <T> List<T> getList(String name) {
            return this.getList(name, List.of());
        }

        @Deprecated(forRemoval=true)
        default public List<List<Double>> getNestedDoubleArray(String name) {
            return this.getList(name);
        }

        public Properties section(String var1);

        public boolean containsKey(String var1);

        public Map<String, Object> asMap();

        @Override
        @NotNull
        default public Iterator<Map.Entry<String, Object>> iterator() {
            return this.asMap().entrySet().iterator();
        }

        default public int size() {
            return this.asMap().size();
        }
    }

    public static final class MaterialEntry
    implements Entry {
        private final Key key;
        private final int id;
        private final String translationKey;
        private final Supplier<Block> blockSupplier;
        @Nullable
        private Either<Properties, DataComponentMap> prototype;
        private final EntityType entityType;

        private MaterialEntry(String namespace, Properties main) {
            this.prototype = Either.left(main.section("components"));
            this.key = Key.key((String)namespace);
            this.id = main.getInt("id");
            this.translationKey = main.getString("translationKey");
            String blockNamespace = main.getString("correspondingBlock", null);
            this.blockSupplier = blockNamespace != null ? () -> Block.fromKey(blockNamespace) : () -> null;
            Properties spawnEggProperties = main.section("spawnEggProperties");
            this.entityType = spawnEggProperties != null ? EntityType.fromKey(spawnEggProperties.getString("entityType")) : null;
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        @NotNull
        public String translationKey() {
            return this.translationKey;
        }

        @Nullable
        public Block block() {
            return this.blockSupplier.get();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public DataComponentMap prototype() {
            Object object;
            Object object2;
            Either<Properties, DataComponentMap> either = this.prototype;
            if (either instanceof Either.Left) {
                RegistryTranscoder<Object> coder;
                Properties components;
                Either.Left left = (Either.Left)either;
                try {
                    object2 = (Properties)left.value();
                    components = object2;
                    coder = new RegistryTranscoder<Object>(Transcoder.JAVA, MinecraftServer.process());
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                DataComponentMap.Builder builder = DataComponentMap.builder();
                block9: for (Map.Entry<String, Object> entry : components) {
                    String message;
                    Result.Error error;
                    Result result;
                    DataComponent<?> component = DataComponent.fromKey(entry.getKey());
                    Check.notNull(component, "Unknown component {0} in {1}", entry.getKey(), this.key);
                    Result result2 = component.decode(coder, entry.getValue());
                    Objects.requireNonNull(result2);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, (Object)result, n)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            Result.Ok ok = (Result.Ok)result;
                            {
                                Result.Error ok2 = error = ok.value();
                                builder.set(component, ok2);
                            }
                            continue block9;
                        }
                        case 1: 
                    }
                    error = (Result.Error)result;
                    {
                        String string;
                        message = string = error.message();
                    }
                    throw new IllegalStateException("Failed to decode component " + entry.getKey() + " in " + String.valueOf(this.key) + ": " + message);
                }
                DataComponentMap prototype = builder.build();
                Either<Object, DataComponentMap> either2 = this.prototype = !prototype.isEmpty() ? Either.right(prototype) : null;
            }
            if (!((either = this.prototype) instanceof Either.Right)) {
                object = DataComponentMap.EMPTY;
                return object;
            }
            Either.Right right = (Either.Right)either;
            {
                Object dataComponentMap;
                object = dataComponentMap = (object2 = (DataComponentMap)right.value());
                return object;
            }
        }

        public boolean isArmor() {
            Equippable equippableComponent = this.prototype().get(DataComponents.EQUIPPABLE);
            EquipmentSlot equipmentSlot = equippableComponent == null ? null : equippableComponent.slot();
            return equipmentSlot != null && equipmentSlot.isArmor();
        }

        @Nullable
        public EquipmentSlot equipmentSlot() {
            Equippable equippableComponent = this.prototype().get(DataComponents.EQUIPPABLE);
            return equippableComponent == null ? null : equippableComponent.slot();
        }

        @Nullable
        public EntityType spawnEntityType() {
            return this.entityType;
        }
    }

    public static final class EntityEntry
    implements Entry {
        private final Key key;
        private final int id;
        private final String translationKey;
        private final double drag;
        private final double acceleration;
        private final boolean isLiving;
        private final double width;
        private final double height;
        private final double eyeHeight;
        private final int clientTrackingRange;
        private final boolean fireImmune;
        private final Map<String, List<Double>> entityOffsets;
        private final BoundingBox boundingBox;

        public EntityEntry(String namespace, Properties main) {
            this.key = Key.key((String)namespace);
            this.id = main.getInt("id");
            this.translationKey = main.getString("translationKey");
            this.drag = main.getDouble("drag", 0.02);
            this.acceleration = main.getDouble("acceleration", 0.08);
            String packetType = main.getString("packetType").toUpperCase(Locale.ROOT);
            this.isLiving = "LIVING".equals(packetType) || "PLAYER".equals(packetType);
            this.fireImmune = main.getBoolean("fireImmune", false);
            this.clientTrackingRange = main.getInt("clientTrackingRange");
            this.width = main.getDouble("width");
            this.height = main.getDouble("height");
            this.eyeHeight = main.getDouble("eyeHeight");
            this.boundingBox = new BoundingBox(this.width, this.height, this.width);
            HashMap<String, List> entityOffsets = new HashMap<String, List>();
            Properties attachments = main.section("attachments");
            if (attachments != null) {
                Set<String> allAttachments = attachments.asMap().keySet();
                for (String key : allAttachments) {
                    List offset = attachments.getList(key);
                    entityOffsets.put(key, (List)offset.getFirst());
                }
            }
            this.entityOffsets = Map.copyOf(entityOffsets);
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public double drag() {
            return this.drag;
        }

        public double acceleration() {
            return this.acceleration;
        }

        public double horizontalAirResistance() {
            return this.isLiving ? 0.91 : 0.98;
        }

        public double verticalAirResistance() {
            return 1.0 - this.drag();
        }

        public boolean shouldSendAttributes() {
            return this.isLiving;
        }

        public double width() {
            return this.width;
        }

        public double height() {
            return this.height;
        }

        public double eyeHeight() {
            return this.eyeHeight;
        }

        public boolean fireImmune() {
            return this.fireImmune;
        }

        public int clientTrackingRange() {
            return this.clientTrackingRange;
        }

        @Nullable
        public List<Double> entityAttachment(@NotNull String attachmentName) {
            return this.entityOffsets.get(attachmentName);
        }

        @NotNull
        public BoundingBox boundingBox() {
            return this.boundingBox;
        }
    }

    public static final class VillagerProfessionEntry
    implements Entry {
        private final Key key;
        private final int id;
        private final SoundEvent workSound;

        public VillagerProfessionEntry(String namespace, Properties main) {
            this.key = Key.key((String)namespace);
            this.id = main.getInt("id");
            this.workSound = main.containsKey("workSound") ? SoundEvent.fromKey(main.getString("workSound")) : null;
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        @Nullable
        public SoundEvent workSound() {
            return this.workSound;
        }
    }

    public record FeatureFlagEntry(Key key, int id) implements Entry
    {
        public FeatureFlagEntry(String namespace, Properties main) {
            this(Key.key((String)namespace), main.getInt("id"));
        }
    }

    public record FluidEntry(Key key, int id) implements Entry
    {
        public FluidEntry(String namespace, Properties main) {
            this(Key.key((String)namespace), main.getInt("id"));
        }
    }

    public record PotionEffectEntry(Key key, int id, String translationKey, int color, boolean isInstantaneous) implements Entry
    {
        public PotionEffectEntry(String namespace, Properties main) {
            this(Key.key((String)namespace), main.getInt("id"), main.getString("translationKey"), main.getInt("color"), main.getBoolean("instantaneous"));
        }
    }

    public record AttributeEntry(Key key, int id, String translationKey, double defaultValue, boolean clientSync, double maxValue, double minValue) implements Entry
    {
        public AttributeEntry(String namespace, Properties main) {
            this(Key.key((String)namespace), main.getInt("id"), main.getString("translationKey"), main.getDouble("defaultValue"), main.getBoolean("clientSync"), main.getDouble("maxValue"), main.getDouble("minValue"));
        }
    }

    public record GameEventEntry(Key key, Properties main) implements Entry
    {
        public GameEventEntry(String key, Properties main) {
            this(Key.key((String)key), main);
        }
    }

    public record BlockSoundTypeEntry(@NotNull Key key, float volume, float pitch, SoundEvent breakSound, SoundEvent hitSound, SoundEvent fallSound, SoundEvent placeSound, SoundEvent stepSound) {
        public BlockSoundTypeEntry(String namespace, Properties main) {
            this(Key.key((String)namespace), main.getFloat("volume"), main.getFloat("pitch"), SoundEvent.fromKey(main.getString("breakSound")), SoundEvent.fromKey(main.getString("hitSound")), SoundEvent.fromKey(main.getString("fallSound")), SoundEvent.fromKey(main.getString("placeSound")), SoundEvent.fromKey(main.getString("stepSound")));
        }
    }

    public static interface Loader<T extends StaticProtocolObject<T>> {
        public T get(String var1, Properties var2);
    }

    record PropertiesMap(Map<String, Object> map) implements Properties
    {
        PropertiesMap {
            map = Map.copyOf(map);
        }

        @Override
        public String getString(String name, String defaultValue) {
            Object element = this.element(name);
            return element != null ? (String)element : defaultValue;
        }

        @Override
        public String getString(String name) {
            return (String)this.element(name);
        }

        @Override
        public double getDouble(String name, double defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).doubleValue() : defaultValue;
        }

        @Override
        public double getDouble(String name) {
            return ((Number)this.element(name)).doubleValue();
        }

        @Override
        public int getInt(String name, int defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).intValue() : defaultValue;
        }

        @Override
        public int getInt(String name) {
            return ((Number)this.element(name)).intValue();
        }

        @Override
        public float getFloat(String name, float defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).floatValue() : defaultValue;
        }

        @Override
        public float getFloat(String name) {
            return ((Number)this.element(name)).floatValue();
        }

        @Override
        public boolean getBoolean(String name, boolean defaultValue) {
            Object element = this.element(name);
            return element != null ? (Boolean)element : defaultValue;
        }

        @Override
        public boolean getBoolean(String name) {
            return (Boolean)this.element(name);
        }

        @Override
        public <T> List<T> getList(String name, List<T> defaultValue) {
            List<T> element = (List<T>)this.element(name);
            return element != null ? element : defaultValue;
        }

        @Override
        public Properties section(String name) {
            Map map = (Map)this.element(name);
            if (map == null) {
                return null;
            }
            return new PropertiesMap(map);
        }

        @Override
        public boolean containsKey(String name) {
            return this.map.containsKey(name);
        }

        @Override
        public Map<String, Object> asMap() {
            return this.map;
        }

        private <T> T element(String name) {
            return (T)this.map.get(name);
        }

        @Override
        public String toString() {
            AtomicReference<String> string = new AtomicReference<String>("{ ");
            this.map.forEach((? super K s, ? super V object) -> string.set((String)string.get() + " , \"" + s + "\" : \"" + object.toString() + "\""));
            return string.updateAndGet(s -> s.replaceFirst(" , ", "") + "}");
        }
    }

    public static interface Entry {
    }

    @ApiStatus.Internal
    public static enum Resource {
        BANNER_PATTERNS("banner_pattern.json"),
        BIOMES("biome.json"),
        CAT_VARIANTS("cat_variant.json"),
        CHAT_TYPES("chat_type.json"),
        CHICKEN_VARIANTS("chicken_variant.json"),
        COW_VARIANTS("cow_variant.json"),
        DAMAGE_TYPES("damage_type.json"),
        DIALOGS("dialog.json"),
        DIMENSION_TYPES("dimension_type.json"),
        ENCHANTMENTS("enchantment.json"),
        FROG_VARIANTS("frog_variant.json"),
        JUKEBOX_SONGS("jukebox_song.json"),
        INSTRUMENTS("instrument.json"),
        PAINTING_VARIANTS("painting_variant.json"),
        PIG_VARIANTS("pig_variant.json"),
        TRIM_MATERIALS("trim_material.json"),
        TRIM_PATTERNS("trim_pattern.json"),
        WOLF_VARIANTS("wolf_variant.json"),
        WOLF_SOUND_VARIANTS("wolf_sound_variant.json");

        private final String name;

        private Resource(String name) {
            this.name = name;
        }

        @NotNull
        public String fileName() {
            return this.name;
        }
    }
}

