/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biome;

import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.NamespaceID;

public record BiomeParticle(float probability, Option option) {
    public CompoundBinaryTag toNbt() {
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putFloat("probability", this.probability)).put("options", (BinaryTag)this.option.toNbt())).build();
    }

    public static interface Option {
        public CompoundBinaryTag toNbt();
    }

    public record NormalOption(NamespaceID type) implements Option
    {
        @Override
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.type.toString())).build();
        }
    }

    public record ItemOption(ItemStack item) implements Option
    {
        private static final String type = "item";

        @Override
        public CompoundBinaryTag toNbt() {
            return CompoundBinaryTag.empty();
        }
    }

    public record DustOption(float red, float green, float blue, float scale) implements Option
    {
        private static final String type = "dust";

        @Override
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", type)).putFloat("r", this.red)).putFloat("g", this.green)).putFloat("b", this.blue)).putFloat("scale", this.scale)).build();
        }
    }

    public record BlockOption(Block block) implements Option
    {
        private static final String type = "block";

        @Override
        public CompoundBinaryTag toNbt() {
            CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
            builder.putString("type", type);
            builder.putString("Name", this.block.name());
            Map<String, String> propertiesMap = this.block.properties();
            if (!propertiesMap.isEmpty()) {
                CompoundBinaryTag.Builder properties = CompoundBinaryTag.builder();
                propertiesMap.forEach((arg_0, arg_1) -> ((CompoundBinaryTag.Builder)properties).putString(arg_0, arg_1));
                builder.put("Properties", (BinaryTag)properties.build());
            }
            return builder.build();
        }
    }
}

