/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.handshake;

import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientHandshakePacket(int protocolVersion, @NotNull String serverAddress, int serverPort, @NotNull Intent intent) implements ClientPacket
{
    public ClientHandshakePacket(int protocolVersion, @NotNull String serverAddress, int serverPort, @NotNull Intent intent) {
        if (serverAddress.length() > ClientHandshakePacket.getMaxHandshakeLength()) {
            throw new IllegalArgumentException("Server address too long: " + serverAddress.length());
        }
    }

    public ClientHandshakePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.UNSIGNED_SHORT), Intent.fromId(reader.read(NetworkBuffer.VAR_INT)));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.protocolVersion);
        int maxLength = ClientHandshakePacket.getMaxHandshakeLength();
        if (this.serverAddress.length() > maxLength) {
            throw new IllegalArgumentException("serverAddress is " + this.serverAddress.length() + " characters long, maximum allowed is " + maxLength);
        }
        writer.write(NetworkBuffer.STRING, this.serverAddress);
        writer.write(NetworkBuffer.UNSIGNED_SHORT, this.serverPort);
        writer.write(NetworkBuffer.VAR_INT, this.intent.id());
    }

    private static int getMaxHandshakeLength() {
        return BungeeCordProxy.isEnabled() ? (BungeeCordProxy.isBungeeGuardEnabled() ? 2500 : Short.MAX_VALUE) : 255;
    }

    public static enum Intent {
        STATUS,
        LOGIN,
        TRANSFER;


        @NotNull
        public static Intent fromId(int id) {
            return switch (id) {
                case 1 -> STATUS;
                case 2 -> LOGIN;
                case 3 -> TRANSFER;
                default -> throw new IllegalArgumentException("Unknown connection intent: " + id);
            };
        }

        public int id() {
            return this.ordinal() + 1;
        }
    }
}

