/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.PlayerBeginItemUseEvent;
import net.minestom.server.event.player.PlayerUseItemEvent;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemAnimation;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.Consumable;
import net.minestom.server.item.component.Equippable;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.server.play.AcknowledgeBlockChangePacket;
import org.jetbrains.annotations.NotNull;

public class UseItemListener {
    public static void useItemListener(ClientUseItemPacket packet, Player player) {
        PlayerHand hand = packet.hand();
        ItemStack itemStack = player.getItemInHand(hand);
        Material material = itemStack.material();
        Consumable consumable = itemStack.get(ItemComponent.CONSUMABLE);
        long useItemTime = 0L;
        ItemAnimation useAnimation = ItemAnimation.NONE;
        if (material == Material.BOW) {
            useItemTime = 72000L;
            useAnimation = ItemAnimation.BOW;
        } else if (material == Material.CROSSBOW) {
            useItemTime = 7200L;
            useAnimation = ItemAnimation.CROSSBOW;
        } else if (material == Material.SHIELD) {
            useItemTime = 72000L;
            useAnimation = ItemAnimation.BLOCK;
        } else if (material == Material.TRIDENT) {
            useItemTime = 72000L;
            useAnimation = ItemAnimation.SPEAR;
        } else if (material == Material.SPYGLASS) {
            useItemTime = 1200L;
            useAnimation = ItemAnimation.SPYGLASS;
        } else if (material == Material.GOAT_HORN) {
            useItemTime = UseItemListener.getInstrumentTime(itemStack);
            useAnimation = ItemAnimation.TOOT_HORN;
        } else if (material == Material.BRUSH) {
            useItemTime = 200L;
            useAnimation = ItemAnimation.BRUSH;
        } else if (material.name().contains("bundle")) {
            useItemTime = 200L;
            useAnimation = ItemAnimation.BUNDLE;
        } else if (consumable != null) {
            useItemTime = consumable.consumeTicks();
            useAnimation = consumable.animation();
        }
        boolean usingMainHand = player.getItemUseHand() == PlayerHand.MAIN && hand == PlayerHand.OFF;
        PlayerUseItemEvent useItemEvent = new PlayerUseItemEvent(player, hand, itemStack, usingMainHand ? 0L : useItemTime);
        EventDispatcher.call(useItemEvent);
        player.sendPacket(new AcknowledgeBlockChangePacket(packet.sequence()));
        PlayerInventory playerInventory = player.getInventory();
        if (useItemEvent.isCancelled()) {
            playerInventory.update();
            return;
        }
        useItemTime = useItemEvent.getItemUseTime();
        if (useItemTime != 0L) {
            PlayerBeginItemUseEvent beginUseEvent = new PlayerBeginItemUseEvent(player, hand, itemStack, useAnimation, useItemTime);
            EventDispatcher.callCancellable(beginUseEvent, () -> {
                player.setItemInHand(hand, beginUseEvent.getItemStack());
                if (beginUseEvent.getItemUseDuration() <= 0L) {
                    return;
                }
                player.refreshItemUse(hand, beginUseEvent.getItemUseDuration());
                player.refreshActiveHand(true, hand == PlayerHand.OFF, false);
            });
            return;
        }
        Equippable equippable = itemStack.get(ItemComponent.EQUIPPABLE);
        if (equippable != null && equippable.swappable()) {
            ItemStack currentlyEquipped = player.getEquipment(equippable.slot());
            player.setEquipment(equippable.slot(), itemStack);
            player.setItemInHand(hand, currentlyEquipped);
        }
    }

    private static int getInstrumentTime(@NotNull ItemStack itemStack) {
        String instrumentName = itemStack.get(ItemComponent.INSTRUMENT);
        if (instrumentName == null) {
            return 0;
        }
        return 0;
    }
}

